/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.InstantiationUtil;

public final class RuntimeStatefulSerializerFactory<T>
implements TypeSerializerFactory<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CONFIG_KEY_SER = "SER_DATA";
    private static final String CONFIG_KEY_CLASS = "CLASS_DATA";
    private byte[] serializerData;
    private TypeSerializer<T> serializer;
    private transient ClassLoader loader;
    private Class<T> clazz;

    public RuntimeStatefulSerializerFactory() {
    }

    public RuntimeStatefulSerializerFactory(TypeSerializer<T> serializer, Class<T> clazz) {
        this.clazz = clazz;
        this.loader = serializer.getClass().getClassLoader();
        try {
            this.serializerData = InstantiationUtil.serializeObject(serializer);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannt serialize the Serializer.", e);
        }
    }

    public void writeParametersToConfig(Configuration config) {
        try {
            InstantiationUtil.writeObjectToConfig(this.clazz, (Configuration)config, (String)CONFIG_KEY_CLASS);
            config.setBytes(CONFIG_KEY_SER, this.serializerData);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not serialize serializer into the configuration.", e);
        }
    }

    public void readParametersFromConfig(Configuration config, ClassLoader cl) throws ClassNotFoundException {
        if (config == null || cl == null) {
            throw new NullPointerException();
        }
        this.serializerData = config.getBytes(CONFIG_KEY_SER, null);
        if (this.serializerData == null) {
            throw new RuntimeException("Could not find deserializer in the configuration.");
        }
        this.loader = cl;
        try {
            this.clazz = (Class)InstantiationUtil.readObjectFromConfig((Configuration)config, (String)CONFIG_KEY_CLASS, (ClassLoader)cl);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load deserializer from the configuration.", e);
        }
    }

    public TypeSerializer<T> getSerializer() {
        if (this.serializerData != null) {
            try {
                return (TypeSerializer)InstantiationUtil.deserializeObject((byte[])this.serializerData, (ClassLoader)this.loader);
            }
            catch (Exception e) {
                throw new RuntimeException("Repeated instantiation of serializer failed.", e);
            }
        }
        throw new RuntimeException("SerializerFactory has not been initialized from configuration.");
    }

    public Class<T> getDataType() {
        return this.clazz;
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RuntimeStatefulSerializerFactory) {
            RuntimeStatefulSerializerFactory other = (RuntimeStatefulSerializerFactory)obj;
            if (this.serializer == null) {
                this.serializer = this.getSerializer();
            }
            if (other.serializer == null) {
                other.serializer = other.getSerializer();
            }
            return this.clazz == other.clazz && this.serializer.equals(other.serializer);
        }
        return false;
    }
}

