/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.InstantiationUtil;

public final class RuntimeStatelessSerializerFactory<T>
implements TypeSerializerFactory<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CONFIG_KEY_SER = "SER_DATA";
    private static final String CONFIG_KEY_CLASS = "CLASS_DATA";
    private TypeSerializer<T> serializer;
    private Class<T> clazz;

    public RuntimeStatelessSerializerFactory() {
    }

    public RuntimeStatelessSerializerFactory(TypeSerializer<T> serializer, Class<T> clazz) {
        if (serializer == null || clazz == null) {
            throw new NullPointerException();
        }
        if (serializer.isStateful()) {
            throw new IllegalArgumentException("Cannot use the stateless serializer factory with a stateful serializer.");
        }
        this.clazz = clazz;
        this.serializer = serializer;
    }

    public void writeParametersToConfig(Configuration config) {
        try {
            InstantiationUtil.writeObjectToConfig(this.clazz, (Configuration)config, (String)CONFIG_KEY_CLASS);
            InstantiationUtil.writeObjectToConfig(this.serializer, (Configuration)config, (String)CONFIG_KEY_SER);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not serialize serializer into the configuration.", e);
        }
    }

    public void readParametersFromConfig(Configuration config, ClassLoader cl) throws ClassNotFoundException {
        if (config == null || cl == null) {
            throw new NullPointerException();
        }
        try {
            this.clazz = (Class)InstantiationUtil.readObjectFromConfig((Configuration)config, (String)CONFIG_KEY_CLASS, (ClassLoader)cl);
            this.serializer = (TypeSerializer)InstantiationUtil.readObjectFromConfig((Configuration)config, (String)CONFIG_KEY_SER, (ClassLoader)cl);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load deserializer from the configuration.", e);
        }
    }

    public TypeSerializer<T> getSerializer() {
        if (this.serializer != null) {
            return this.serializer;
        }
        throw new RuntimeException("SerializerFactory has not been initialized from configuration.");
    }

    public Class<T> getDataType() {
        return this.clazz;
    }

    public int hashCode() {
        return this.clazz.hashCode() ^ this.serializer.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RuntimeStatelessSerializerFactory) {
            RuntimeStatelessSerializerFactory other = (RuntimeStatelessSerializerFactory)obj;
            return this.clazz == other.clazz && this.serializer.equals(other.serializer);
        }
        return false;
    }
}

