/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.collector.OutputSelector;
import org.apache.flink.streaming.api.invokable.StreamInvokable;
import org.apache.flink.streaming.api.streamrecord.StreamRecordSerializer;
import org.apache.flink.streaming.api.streamvertex.StreamVertexException;
import org.apache.flink.streaming.partitioner.ShufflePartitioner;
import org.apache.flink.streaming.partitioner.StreamPartitioner;
import org.apache.flink.streaming.state.OperatorState;
import org.apache.flink.util.InstantiationUtil;

public class StreamConfig {
    private static final String INPUT_TYPE = "inputType_";
    private static final String NUMBER_OF_OUTPUTS = "numberOfOutputs";
    private static final String NUMBER_OF_INPUTS = "numberOfInputs";
    private static final String OUTPUT_NAME = "outputName_";
    private static final String OUTPUT_SELECT_ALL = "outputSelectAll_";
    private static final String PARTITIONER_OBJECT = "partitionerObject_";
    private static final String NUMBER_OF_OUTPUT_CHANNELS = "numOfOutputs_";
    private static final String ITERATION_ID = "iteration-id";
    private static final String OUTPUT_SELECTOR = "outputSelector";
    private static final String DIRECTED_EMIT = "directedEmit";
    private static final String FUNCTION_NAME = "operatorName";
    private static final String VERTEX_NAME = "vertexName";
    private static final String SERIALIZEDUDF = "serializedudf";
    private static final String USER_FUNCTION = "userfunction";
    private static final String BUFFER_TIMEOUT = "bufferTimeout";
    private static final String OPERATOR_STATES = "operatorStates";
    private static final String TYPE_SERIALIZER_IN_1 = "typeSerializer_in_1";
    private static final String TYPE_SERIALIZER_IN_2 = "typeSerializer_in_2";
    private static final String TYPE_SERIALIZER_OUT_1 = "typeSerializer_out_1";
    private static final String TYPE_SERIALIZER_OUT_2 = "typeSerializer_out_2";
    private static final String ITERATON_WAIT = "iterationWait";
    private static final long DEFAULT_TIMEOUT = 100L;
    private Configuration config;

    public StreamConfig(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setTypeSerializerIn1(StreamRecordSerializer<?> serializer) {
        this.setTypeSerializer(TYPE_SERIALIZER_IN_1, serializer);
    }

    public void setTypeSerializerIn2(StreamRecordSerializer<?> serializer) {
        this.setTypeSerializer(TYPE_SERIALIZER_IN_2, serializer);
    }

    public void setTypeSerializerOut1(StreamRecordSerializer<?> serializer) {
        this.setTypeSerializer(TYPE_SERIALIZER_OUT_1, serializer);
    }

    public void setTypeSerializerOut2(StreamRecordSerializer<?> serializer) {
        this.setTypeSerializer(TYPE_SERIALIZER_OUT_2, serializer);
    }

    public <T> StreamRecordSerializer<T> getTypeSerializerIn1(ClassLoader cl) {
        try {
            return (StreamRecordSerializer)((Object)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)TYPE_SERIALIZER_IN_1, (ClassLoader)cl));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate serializer.");
        }
    }

    public <T> StreamRecordSerializer<T> getTypeSerializerIn2(ClassLoader cl) {
        try {
            return (StreamRecordSerializer)((Object)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)TYPE_SERIALIZER_IN_2, (ClassLoader)cl));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate serializer.");
        }
    }

    public <T> StreamRecordSerializer<T> getTypeSerializerOut1(ClassLoader cl) {
        try {
            return (StreamRecordSerializer)((Object)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)TYPE_SERIALIZER_OUT_1, (ClassLoader)cl));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate serializer.");
        }
    }

    public <T> StreamRecordSerializer<T> getTypeSerializerOut2(ClassLoader cl) {
        try {
            return (StreamRecordSerializer)((Object)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)TYPE_SERIALIZER_OUT_2, (ClassLoader)cl));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate serializer.");
        }
    }

    private void setTypeSerializer(String key, StreamRecordSerializer<?> typeWrapper) {
        this.config.setBytes(key, SerializationUtils.serialize(typeWrapper));
    }

    public void setBufferTimeout(long timeout) {
        this.config.setLong(BUFFER_TIMEOUT, timeout);
    }

    public long getBufferTimeout() {
        return this.config.getLong(BUFFER_TIMEOUT, 100L);
    }

    public void setUserInvokable(StreamInvokable<?, ?> invokableObject) {
        if (invokableObject != null) {
            this.config.setClass(USER_FUNCTION, invokableObject.getClass());
            try {
                this.config.setBytes(SERIALIZEDUDF, SerializationUtils.serialize(invokableObject));
            }
            catch (SerializationException e) {
                throw new RuntimeException("Cannot serialize invokable object " + invokableObject.getClass(), e);
            }
        }
    }

    public <T> T getUserInvokable(ClassLoader cl) {
        try {
            return (T)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)SERIALIZEDUDF, (ClassLoader)cl);
        }
        catch (Exception e) {
            throw new StreamVertexException("Cannot instantiate user function", e);
        }
    }

    public void setVertexName(String vertexName) {
        this.config.setString(VERTEX_NAME, vertexName);
    }

    public String getVertexName() {
        return this.config.getString(VERTEX_NAME, null);
    }

    public String getFunctionName() {
        return this.config.getString(FUNCTION_NAME, "");
    }

    public void setDirectedEmit(boolean directedEmit) {
        this.config.setBoolean(DIRECTED_EMIT, directedEmit);
    }

    public boolean getDirectedEmit() {
        return this.config.getBoolean(DIRECTED_EMIT, false);
    }

    public void setOutputSelector(byte[] outputSelector) {
        if (outputSelector != null) {
            this.setDirectedEmit(true);
            this.config.setBytes(OUTPUT_SELECTOR, outputSelector);
        }
    }

    public <T> OutputSelector<T> getOutputSelector(ClassLoader cl) {
        try {
            return (OutputSelector)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)OUTPUT_SELECTOR, (ClassLoader)cl);
        }
        catch (Exception e) {
            throw new StreamVertexException("Cannot deserialize and instantiate OutputSelector", e);
        }
    }

    public void setIterationId(Integer iterationId) {
        this.config.setInteger(ITERATION_ID, iterationId.intValue());
    }

    public Integer getIterationId() {
        return this.config.getInteger(ITERATION_ID, 0);
    }

    public void setIterationWaitTime(long time) {
        this.config.setLong(ITERATON_WAIT, time);
    }

    public long getIterationWaitTime() {
        return this.config.getLong(ITERATON_WAIT, 0L);
    }

    public void setNumberOfOutputChannels(int outputIndex, Integer numberOfOutputChannels) {
        this.config.setInteger(NUMBER_OF_OUTPUT_CHANNELS + outputIndex, numberOfOutputChannels.intValue());
    }

    public int getNumberOfOutputChannels(int outputIndex) {
        return this.config.getInteger(NUMBER_OF_OUTPUT_CHANNELS + outputIndex, 0);
    }

    public <T> void setPartitioner(int outputIndex, StreamPartitioner<T> partitionerObject) {
        this.config.setBytes(PARTITIONER_OBJECT + outputIndex, SerializationUtils.serialize(partitionerObject));
    }

    public <T> StreamPartitioner<T> getPartitioner(ClassLoader cl, int outputIndex) throws ClassNotFoundException, IOException {
        StreamPartitioner partitioner = (StreamPartitioner)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)(PARTITIONER_OBJECT + outputIndex), (ClassLoader)cl);
        if (partitioner != null) {
            return partitioner;
        }
        return new ShufflePartitioner();
    }

    public void setSelectAll(int outputIndex, Boolean selectAll) {
        if (selectAll != null) {
            this.config.setBoolean(OUTPUT_SELECT_ALL + outputIndex, selectAll.booleanValue());
        }
    }

    public boolean getSelectAll(int outputIndex) {
        return this.config.getBoolean(OUTPUT_SELECT_ALL + outputIndex, false);
    }

    public void setOutputName(int outputIndex, List<String> outputName) {
        if (outputName != null) {
            this.config.setBytes(OUTPUT_NAME + outputIndex, SerializationUtils.serialize((Serializable)((Serializable)((Object)outputName))));
        }
    }

    public List<String> getOutputName(int outputIndex) {
        return (List)SerializationUtils.deserialize((byte[])this.config.getBytes(OUTPUT_NAME + outputIndex, null));
    }

    public void setNumberOfInputs(int numberOfInputs) {
        this.config.setInteger(NUMBER_OF_INPUTS, numberOfInputs);
    }

    public int getNumberOfInputs() {
        return this.config.getInteger(NUMBER_OF_INPUTS, 0);
    }

    public void setNumberOfOutputs(int numberOfOutputs) {
        this.config.setInteger(NUMBER_OF_OUTPUTS, numberOfOutputs);
    }

    public int getNumberOfOutputs() {
        return this.config.getInteger(NUMBER_OF_OUTPUTS, 0);
    }

    public void setInputType(int inputNumber, Integer inputTypeNumber) {
        this.config.setInteger(INPUT_TYPE + inputNumber++, inputTypeNumber.intValue());
    }

    public int getInputType(int inputNumber) {
        return this.config.getInteger(INPUT_TYPE + inputNumber, 0);
    }

    public void setFunctionClass(Class<? extends AbstractRichFunction> functionClass) {
        this.config.setClass("functionClass", functionClass);
    }

    public Class<? extends AbstractRichFunction> getFunctionClass(ClassLoader cl) {
        try {
            return this.config.getClass("functionClass", null, cl);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load function class", e);
        }
    }

    public void setOperatorStates(Map<String, OperatorState<?>> states) {
        this.config.setBytes(OPERATOR_STATES, SerializationUtils.serialize((Serializable)((Serializable)((Object)states))));
    }

    public Map<String, OperatorState<?>> getOperatorStates(ClassLoader cl) {
        try {
            return (Map)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)OPERATOR_STATES, (ClassLoader)cl);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load operator state");
        }
    }
}

