/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.collector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.io.network.api.RecordWriter;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.util.Collector;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCollector<OUT>
implements Collector<OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamCollector.class);
    protected StreamRecord<OUT> streamRecord;
    protected int channelID;
    protected List<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>> outputs;
    protected Map<String, List<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>>> outputMap;
    protected SerializationDelegate<StreamRecord<OUT>> serializationDelegate;

    public StreamCollector(int channelID, SerializationDelegate<StreamRecord<OUT>> serializationDelegate) {
        this.serializationDelegate = serializationDelegate;
        this.streamRecord = serializationDelegate != null ? (StreamRecord)serializationDelegate.getInstance() : new StreamRecord();
        this.channelID = channelID;
        this.outputs = new ArrayList<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>>();
        this.outputMap = new HashMap<String, List<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>>>();
    }

    public void addOutput(RecordWriter<SerializationDelegate<StreamRecord<OUT>>> output, List<String> outputNames, boolean isSelectAllOutput) {
        this.addOneOutput(output, outputNames, isSelectAllOutput);
    }

    protected void addOneOutput(RecordWriter<SerializationDelegate<StreamRecord<OUT>>> output, List<String> outputNames, boolean isSelectAllOutput) {
        this.outputs.add(output);
        for (String outputName : outputNames) {
            if (outputName == null) continue;
            if (!this.outputMap.containsKey(outputName)) {
                this.outputMap.put(outputName, new ArrayList());
                this.outputMap.get(outputName).add(output);
                continue;
            }
            if (this.outputMap.get(outputName).contains(output)) continue;
            this.outputMap.get(outputName).add(output);
        }
    }

    public void collect(OUT outputObject) {
        this.streamRecord.setObject(outputObject);
        this.emit(this.streamRecord);
    }

    private void emit(StreamRecord<OUT> streamRecord) {
        streamRecord.newId(this.channelID);
        this.serializationDelegate.setInstance(streamRecord);
        this.emitToOutputs();
    }

    protected void emitToOutputs() {
        for (RecordWriter<SerializationDelegate<StreamRecord<OUT>>> output : this.outputs) {
            try {
                output.emit(this.serializationDelegate);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Emit failed due to: {}", (Object)StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    public void close() {
    }
}

