/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.JobGraphBuilder;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.GroupedDataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.function.co.CoFlatMapFunction;
import org.apache.flink.streaming.api.function.co.CoMapFunction;
import org.apache.flink.streaming.api.function.co.CoReduceFunction;
import org.apache.flink.streaming.api.function.co.CoWindowFunction;
import org.apache.flink.streaming.api.invokable.operator.co.CoFlatMapInvokable;
import org.apache.flink.streaming.api.invokable.operator.co.CoGroupedReduceInvokable;
import org.apache.flink.streaming.api.invokable.operator.co.CoInvokable;
import org.apache.flink.streaming.api.invokable.operator.co.CoMapInvokable;
import org.apache.flink.streaming.api.invokable.operator.co.CoReduceInvokable;
import org.apache.flink.streaming.api.invokable.operator.co.CoWindowInvokable;
import org.apache.flink.streaming.api.windowing.helper.SystemTimestamp;
import org.apache.flink.streaming.api.windowing.helper.TimestampWrapper;

public class ConnectedDataStream<IN1, IN2> {
    protected StreamExecutionEnvironment environment;
    protected JobGraphBuilder jobGraphBuilder;
    protected DataStream<IN1> dataStream1;
    protected DataStream<IN2> dataStream2;
    protected boolean isGrouped;
    protected KeySelector<IN1, ?> keySelector1;
    protected KeySelector<IN2, ?> keySelector2;

    protected ConnectedDataStream(DataStream<IN1> input1, DataStream<IN2> input2) {
        this.jobGraphBuilder = input1.jobGraphBuilder;
        this.environment = input1.environment;
        this.dataStream1 = input1.copy();
        this.dataStream2 = input2.copy();
        if (input1 instanceof GroupedDataStream && input2 instanceof GroupedDataStream) {
            this.isGrouped = true;
            this.keySelector1 = ((GroupedDataStream)input1).keySelector;
            this.keySelector2 = ((GroupedDataStream)input2).keySelector;
        } else {
            this.isGrouped = false;
            this.keySelector1 = null;
            this.keySelector2 = null;
        }
    }

    protected ConnectedDataStream(ConnectedDataStream<IN1, IN2> coDataStream) {
        this.jobGraphBuilder = coDataStream.jobGraphBuilder;
        this.environment = coDataStream.environment;
        this.dataStream1 = coDataStream.getFirst();
        this.dataStream2 = coDataStream.getSecond();
        this.isGrouped = coDataStream.isGrouped;
        this.keySelector1 = coDataStream.keySelector1;
        this.keySelector2 = coDataStream.keySelector2;
    }

    public <F> F clean(F f) {
        if (this.getExecutionEnvironment().getConfig().isClosureCleanerEnabled()) {
            ClosureCleaner.clean(f, (boolean)true);
        }
        ClosureCleaner.ensureSerializable(f);
        return f;
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.environment;
    }

    public DataStream<IN1> getFirst() {
        return this.dataStream1.copy();
    }

    public DataStream<IN2> getSecond() {
        return this.dataStream2.copy();
    }

    public TypeInformation<IN1> getInputType1() {
        return this.dataStream1.getType();
    }

    public TypeInformation<IN2> getInputType2() {
        return this.dataStream2.getType();
    }

    public ConnectedDataStream<IN1, IN2> groupBy(int keyPosition1, int keyPosition2) {
        return new ConnectedDataStream<IN1, IN2>(this.dataStream1.groupBy(keyPosition1), this.dataStream2.groupBy(keyPosition2));
    }

    public ConnectedDataStream<IN1, IN2> groupBy(int[] keyPositions1, int[] keyPositions2) {
        return new ConnectedDataStream<IN1, IN2>(this.dataStream1.groupBy(keyPositions1), this.dataStream2.groupBy(keyPositions2));
    }

    public ConnectedDataStream<IN1, IN2> groupBy(String field1, String field2) {
        return new ConnectedDataStream<IN1, IN2>(this.dataStream1.groupBy(field1), this.dataStream2.groupBy(field2));
    }

    public ConnectedDataStream<IN1, IN2> groupBy(String[] fields1, String[] fields2) {
        return new ConnectedDataStream<IN1, IN2>(this.dataStream1.groupBy(fields1), this.dataStream2.groupBy(fields2));
    }

    public ConnectedDataStream<IN1, IN2> groupBy(KeySelector<IN1, ?> keySelector1, KeySelector<IN2, ?> keySelector2) {
        return new ConnectedDataStream<IN1, IN2>(this.dataStream1.groupBy(keySelector1), this.dataStream2.groupBy(keySelector2));
    }

    public <OUT> SingleOutputStreamOperator<OUT, ?> map(CoMapFunction<IN1, IN2, OUT> coMapper) {
        TypeInformation outTypeInfo = TypeExtractor.createTypeInfo(CoMapFunction.class, coMapper.getClass(), (int)2, null, null);
        return this.addCoFunction("coMap", outTypeInfo, new CoMapInvokable<IN1, IN2, OUT>(this.clean(coMapper)));
    }

    public <OUT> SingleOutputStreamOperator<OUT, ?> flatMap(CoFlatMapFunction<IN1, IN2, OUT> coFlatMapper) {
        TypeInformation outTypeInfo = TypeExtractor.createTypeInfo(CoFlatMapFunction.class, coFlatMapper.getClass(), (int)2, null, null);
        return this.addCoFunction("coFlatMap", outTypeInfo, new CoFlatMapInvokable<IN1, IN2, OUT>(this.clean(coFlatMapper)));
    }

    public <OUT> SingleOutputStreamOperator<OUT, ?> reduce(CoReduceFunction<IN1, IN2, OUT> coReducer) {
        TypeInformation outTypeInfo = TypeExtractor.createTypeInfo(CoReduceFunction.class, coReducer.getClass(), (int)2, null, null);
        return this.addCoFunction("coReduce", outTypeInfo, this.getReduceInvokable(this.clean(coReducer)));
    }

    public <OUT> SingleOutputStreamOperator<OUT, ?> windowReduce(CoWindowFunction<IN1, IN2, OUT> coWindowFunction, long windowSize, long slideInterval) {
        return this.windowReduce(coWindowFunction, windowSize, slideInterval, SystemTimestamp.getWrapper(), SystemTimestamp.getWrapper());
    }

    public <OUT> SingleOutputStreamOperator<OUT, ?> windowReduce(CoWindowFunction<IN1, IN2, OUT> coWindowFunction, long windowSize, long slideInterval, TimestampWrapper<IN1> timestamp1, TimestampWrapper<IN2> timestamp2) {
        if (windowSize < 1L) {
            throw new IllegalArgumentException("Window size must be positive");
        }
        if (slideInterval < 1L) {
            throw new IllegalArgumentException("Slide interval must be positive");
        }
        TypeInformation outTypeInfo = TypeExtractor.createTypeInfo(CoWindowFunction.class, coWindowFunction.getClass(), (int)2, null, null);
        return this.addCoFunction("coWindowReduce", outTypeInfo, new CoWindowInvokable<IN1, IN2, OUT>(this.clean(coWindowFunction), windowSize, slideInterval, timestamp1, timestamp2));
    }

    protected <OUT> CoInvokable<IN1, IN2, OUT> getReduceInvokable(CoReduceFunction<IN1, IN2, OUT> coReducer) {
        CoReduceInvokable invokable = this.isGrouped ? new CoGroupedReduceInvokable<IN1, IN2, OUT>(this.clean(coReducer), this.keySelector1, this.keySelector2) : new CoReduceInvokable(this.clean(coReducer));
        return invokable;
    }

    public <OUT> SingleOutputStreamOperator<OUT, ?> addGeneralWindowCombine(CoWindowFunction<IN1, IN2, OUT> coWindowFunction, TypeInformation<OUT> outTypeInfo, long windowSize, long slideInterval, TimestampWrapper<IN1> timestamp1, TimestampWrapper<IN2> timestamp2) {
        if (windowSize < 1L) {
            throw new IllegalArgumentException("Window size must be positive");
        }
        if (slideInterval < 1L) {
            throw new IllegalArgumentException("Slide interval must be positive");
        }
        return this.addCoFunction("coWindowReduce", outTypeInfo, new CoWindowInvokable<IN1, IN2, OUT>(this.clean(coWindowFunction), windowSize, slideInterval, timestamp1, timestamp2));
    }

    public <OUT> SingleOutputStreamOperator<OUT, ?> addCoFunction(String functionName, TypeInformation<OUT> outTypeInfo, CoInvokable<IN1, IN2, OUT> functionInvokable) {
        SingleOutputStreamOperator returnStream = new SingleOutputStreamOperator(this.environment, functionName, outTypeInfo);
        this.dataStream1.jobGraphBuilder.addCoTask(returnStream.getId(), functionInvokable, this.getInputType1(), this.getInputType2(), outTypeInfo, functionName, this.environment.getDegreeOfParallelism());
        this.dataStream1.connectGraph(this.dataStream1, returnStream.getId(), 1);
        this.dataStream1.connectGraph(this.dataStream2, returnStream.getId(), 2);
        return returnStream;
    }

    protected ConnectedDataStream<IN1, IN2> copy() {
        return new ConnectedDataStream<IN1, IN2>(this);
    }
}

