/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.function.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.invokable.operator.GroupedReduceInvokable;
import org.apache.flink.streaming.partitioner.StreamPartitioner;

public class GroupedDataStream<OUT>
extends DataStream<OUT> {
    KeySelector<OUT, ?> keySelector;

    protected GroupedDataStream(DataStream<OUT> dataStream, KeySelector<OUT, ?> keySelector) {
        super(dataStream.partitionBy(keySelector));
        this.keySelector = keySelector;
    }

    protected GroupedDataStream(GroupedDataStream<OUT> dataStream) {
        super(dataStream);
        this.keySelector = dataStream.keySelector;
    }

    public KeySelector<OUT, ?> getKeySelector() {
        return this.keySelector;
    }

    @Override
    public SingleOutputStreamOperator<OUT, ?> reduce(ReduceFunction<OUT> reducer) {
        return this.transform("groupReduce", this.getType(), new GroupedReduceInvokable<OUT>(this.clean(reducer), this.keySelector));
    }

    @Override
    public SingleOutputStreamOperator<OUT, ?> sum(int positionToSum) {
        return super.sum(positionToSum);
    }

    @Override
    public SingleOutputStreamOperator<OUT, ?> min(int positionToMin) {
        return super.min(positionToMin);
    }

    @Override
    public SingleOutputStreamOperator<OUT, ?> minBy(int positionToMinBy) {
        return super.minBy(positionToMinBy);
    }

    @Override
    public SingleOutputStreamOperator<OUT, ?> minBy(int positionToMinBy, boolean first) {
        return super.minBy(positionToMinBy, first);
    }

    @Override
    public SingleOutputStreamOperator<OUT, ?> max(int positionToMax) {
        return super.max(positionToMax);
    }

    @Override
    public SingleOutputStreamOperator<OUT, ?> maxBy(int positionToMaxBy) {
        return super.maxBy(positionToMaxBy);
    }

    @Override
    public SingleOutputStreamOperator<OUT, ?> maxBy(int positionToMaxBy, boolean first) {
        return super.maxBy(positionToMaxBy, first);
    }

    @Override
    protected SingleOutputStreamOperator<OUT, ?> aggregate(AggregationFunction<OUT> aggregate) {
        GroupedReduceInvokable<OUT> invokable = new GroupedReduceInvokable<OUT>((ReduceFunction)this.clean(aggregate), this.keySelector);
        SingleOutputStreamOperator returnStream = this.transform("groupReduce", this.getType(), invokable);
        return returnStream;
    }

    @Override
    protected DataStream<OUT> setConnectionType(StreamPartitioner<OUT> partitioner) {
        System.out.println("Setting the partitioning after groupBy can affect the grouping");
        return super.setConnectionType(partitioner);
    }

    @Override
    public GroupedDataStream<OUT> copy() {
        return new GroupedDataStream<OUT>(this);
    }
}

