/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.io.File;
import java.util.List;
import org.apache.flink.client.program.Client;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

public class StreamContextEnvironment
extends StreamExecutionEnvironment {
    protected static ClassLoader userClassLoader;
    protected List<File> jars;
    protected Client client;

    protected StreamContextEnvironment(Client client, List<File> jars, int dop) {
        this.client = client;
        this.jars = jars;
        if (dop > 0) {
            this.setDegreeOfParallelism(dop);
        } else {
            this.setDegreeOfParallelism(GlobalConfiguration.getInteger((String)"parallelization.degree.default", (int)1));
        }
    }

    @Override
    public void execute() throws Exception {
        this.execute(null);
    }

    @Override
    public void execute(String jobName) throws Exception {
        JobGraph jobGraph = jobName == null ? this.jobGraphBuilder.getJobGraph() : this.jobGraphBuilder.getJobGraph(jobName);
        for (File file : this.jars) {
            jobGraph.addJar(new Path(file.getAbsolutePath()));
        }
        this.client.run(jobGraph, true);
    }
}

