/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.function.aggregation;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.PojoComparator;
import org.apache.flink.streaming.api.function.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.function.aggregation.SumFunction;

public abstract class SumAggregator {
    public static <T> ReduceFunction<T> getSumFunction(int pos, Class<?> clazz, TypeInformation<T> typeInfo) {
        if (typeInfo.isTupleType()) {
            return new TupleSumAggregator(pos, SumFunction.getForClass(clazz));
        }
        if (typeInfo instanceof BasicArrayTypeInfo || typeInfo instanceof PrimitiveArrayTypeInfo) {
            return new ArraySumAggregator(pos, SumFunction.getForClass(clazz));
        }
        return new SimpleSumAggregator(SumFunction.getForClass(clazz));
    }

    public static <T> ReduceFunction<T> getSumFunction(String field, TypeInformation<T> typeInfo) {
        return new PojoSumAggregator(field, typeInfo);
    }

    private static class PojoSumAggregator<T>
    extends AggregationFunction<T> {
        private static final long serialVersionUID = 1L;
        SumFunction adder;
        PojoComparator<T> comparator;

        public PojoSumAggregator(String field, TypeInformation<?> type) {
            super(0);
            if (!(type instanceof CompositeType)) {
                throw new IllegalArgumentException("Key expressions are only supported on POJO types and Tuples. A type is considered a POJO if all its fields are public, or have both getters and setters defined");
            }
            CompositeType cType = (CompositeType)type;
            ArrayList fieldDescriptors = new ArrayList();
            cType.getKey(field, 0, fieldDescriptors);
            int logicalKeyPosition = ((CompositeType.FlatFieldDescriptor)fieldDescriptors.get(0)).getPosition();
            Class keyClass = ((CompositeType.FlatFieldDescriptor)fieldDescriptors.get(0)).getType().getTypeClass();
            this.adder = SumFunction.getForClass(keyClass);
            if (!(cType instanceof PojoTypeInfo)) {
                throw new IllegalArgumentException("Key expressions are only supported on POJO types. A type is considered a POJO if all its fields are public, or have both getters and setters defined");
            }
            this.comparator = (PojoComparator)cType.createComparator(new int[]{logicalKeyPosition}, new boolean[]{false}, 0);
        }

        public T reduce(T value1, T value2) throws Exception {
            Field[] keyFields = this.comparator.getKeyFields();
            Object field1 = this.comparator.accessField(keyFields[0], value1);
            Object field2 = this.comparator.accessField(keyFields[0], value2);
            keyFields[0].set(value2, this.adder.add(field1, field2));
            return value2;
        }
    }

    private static class SimpleSumAggregator<T>
    extends AggregationFunction<T> {
        private static final long serialVersionUID = 1L;
        SumFunction adder;

        public SimpleSumAggregator(SumFunction adder) {
            super(0);
            this.adder = adder;
        }

        public T reduce(T value1, T value2) throws Exception {
            return (T)this.adder.add(value1, value2);
        }
    }

    private static class ArraySumAggregator<T>
    extends AggregationFunction<T> {
        private static final long serialVersionUID = 1L;
        SumFunction adder;

        public ArraySumAggregator(int pos, SumFunction adder) {
            super(pos);
            this.adder = adder;
        }

        public T reduce(T value1, T value2) throws Exception {
            Object v1 = Array.get(value1, this.position);
            Object v2 = Array.get(value2, this.position);
            Array.set(value2, this.position, this.adder.add(v1, v2));
            return value2;
        }
    }

    private static class TupleSumAggregator<T>
    extends AggregationFunction<T> {
        private static final long serialVersionUID = 1L;
        SumFunction adder;

        public TupleSumAggregator(int pos, SumFunction adder) {
            super(pos);
            this.adder = adder;
        }

        public T reduce(T value1, T value2) throws Exception {
            Tuple tuple1 = (Tuple)value1;
            Tuple tuple2 = (Tuple)value2;
            tuple2.setField(this.adder.add(tuple1.getField(this.position), tuple2.getField(this.position)), this.position);
            return (T)tuple2;
        }
    }
}

