/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.function.aggregation;

import java.io.Serializable;

public abstract class SumFunction
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract Object add(Object var1, Object var2);

    public static SumFunction getForClass(Class<?> clazz) {
        if (clazz == Integer.class) {
            return new IntSum();
        }
        if (clazz == Long.class) {
            return new LongSum();
        }
        if (clazz == Short.class) {
            return new ShortSum();
        }
        if (clazz == Double.class) {
            return new DoubleSum();
        }
        if (clazz == Float.class) {
            return new FloatSum();
        }
        if (clazz == Byte.class) {
            return new ByteSum();
        }
        throw new RuntimeException("DataStream cannot be summed because the class " + clazz.getSimpleName() + " does not support the + operator.");
    }

    public static class ByteSum
    extends SumFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public Object add(Object value1, Object value2) {
            return (Byte)value1 + (Byte)value2;
        }
    }

    public static class FloatSum
    extends SumFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public Object add(Object value1, Object value2) {
            return Float.valueOf(((Float)value1).floatValue() + ((Float)value2).floatValue());
        }
    }

    public static class ShortSum
    extends SumFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public Object add(Object value1, Object value2) {
            return (Short)value1 + (Short)value2;
        }
    }

    public static class DoubleSum
    extends SumFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public Object add(Object value1, Object value2) {
            return (Double)value1 + (Double)value2;
        }
    }

    public static class LongSum
    extends SumFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public Object add(Object value1, Object value2) {
            return (Long)value1 + (Long)value2;
        }
    }

    public static class IntSum
    extends SumFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public Object add(Object value1, Object value2) {
            return (Integer)value1 + (Integer)value2;
        }
    }
}

