/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.function.source;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.api.java.typeutils.runtime.RuntimeStatefulSerializerFactory;
import org.apache.flink.api.java.typeutils.runtime.RuntimeStatelessSerializerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.streaming.api.function.source.RichSourceFunction;
import org.apache.flink.streaming.api.streamvertex.StreamingRuntimeContext;
import org.apache.flink.util.Collector;

public class FileSourceFunction
extends RichSourceFunction<String> {
    private static final long serialVersionUID = 1L;
    private InputSplitProvider provider;
    private InputFormat<String, ?> inputFormat;
    private TypeSerializerFactory<String> serializerFactory;

    public FileSourceFunction(InputFormat<String, ?> format, TypeInformation<String> typeInfo) {
        this.inputFormat = format;
        this.serializerFactory = FileSourceFunction.createSerializer(typeInfo);
    }

    private static TypeSerializerFactory<String> createSerializer(TypeInformation<String> typeInfo) {
        TypeSerializer serializer = typeInfo.createSerializer();
        if (serializer.isStateful()) {
            return new RuntimeStatefulSerializerFactory(serializer, typeInfo.getTypeClass());
        }
        return new RuntimeStatelessSerializerFactory(serializer, typeInfo.getTypeClass());
    }

    public void open(Configuration parameters) throws Exception {
        StreamingRuntimeContext context = (StreamingRuntimeContext)this.getRuntimeContext();
        this.provider = context.getInputSplitProvider();
        this.inputFormat.configure(context.getTaskStubParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Collector<String> collector) throws Exception {
        TypeSerializer serializer = this.serializerFactory.getSerializer();
        Iterator<InputSplit> splitIterator = this.getInputSplits();
        InputFormat<String, ?> format = this.inputFormat;
        try {
            while (splitIterator.hasNext()) {
                InputSplit split = splitIterator.next();
                String record = (String)serializer.createInstance();
                format.open(split);
                try {
                    while (!format.reachedEnd()) {
                        if ((record = (String)format.nextRecord((Object)record)) == null) continue;
                        collector.collect((Object)record);
                    }
                }
                finally {
                    format.close();
                }
            }
            collector.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Iterator<InputSplit> getInputSplits() {
        return new Iterator<InputSplit>(){
            private InputSplit nextSplit;
            private boolean exhausted;

            @Override
            public boolean hasNext() {
                if (this.exhausted) {
                    return false;
                }
                if (this.nextSplit != null) {
                    return true;
                }
                InputSplit split = FileSourceFunction.this.provider.getNextInputSplit();
                if (split != null) {
                    this.nextSplit = split;
                    return true;
                }
                this.exhausted = true;
                return false;
            }

            @Override
            public InputSplit next() {
                if (this.nextSplit == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                InputSplit tmp = this.nextSplit;
                this.nextSplit = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

