/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.function.source;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.function.source.RichSourceFunction;
import org.apache.flink.util.Collector;

public class SocketTextStreamFunction
extends RichSourceFunction<String> {
    private static final long serialVersionUID = 1L;
    private String hostname;
    private int port;
    private char delimiter;
    private Socket socket;
    private static final int CONNECTION_TIMEOUT_TIME = 0;

    public SocketTextStreamFunction(String hostname, int port, char delimiter) {
        this.hostname = hostname;
        this.port = port;
        this.delimiter = delimiter;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(this.hostname, this.port), 0);
    }

    @Override
    public void invoke(Collector<String> collector) throws Exception {
        while (!this.socket.isClosed() && this.socket.isConnected()) {
            this.streamFromSocket(collector, this.socket);
        }
    }

    public void streamFromSocket(Collector<String> collector, Socket socket) throws Exception {
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        while (true) {
            int data = reader.read();
            if (!socket.isConnected() || socket.isClosed() || data == -1) break;
            if (data == this.delimiter) {
                collector.collect((Object)buffer.toString());
                buffer = new StringBuffer();
                continue;
            }
            if (data == 13) continue;
            buffer.append((char)data);
        }
        if (buffer.length() > 0) {
            collector.collect((Object)buffer.toString());
        }
    }

    public void close() throws Exception {
        this.socket.close();
        super.close();
    }
}

