/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.invokable.operator.StreamReduceInvokable;

public class GroupedReduceInvokable<IN>
extends StreamReduceInvokable<IN> {
    private static final long serialVersionUID = 1L;
    private KeySelector<IN, ?> keySelector;
    private Map<Object, IN> values;
    private IN reduced;

    public GroupedReduceInvokable(ReduceFunction<IN> reducer, KeySelector<IN, ?> keySelector) {
        super(reducer);
        this.keySelector = keySelector;
        this.values = new HashMap<Object, IN>();
    }

    @Override
    protected void reduce() throws Exception {
        Object key = this.nextRecord.getKey(this.keySelector);
        this.currentValue = this.values.get(key);
        this.nextValue = this.nextRecord.getObject();
        if (this.currentValue != null) {
            this.callUserFunctionAndLogException();
            this.values.put(key, this.reduced);
            this.collector.collect(this.reduced);
        } else {
            this.values.put(key, this.nextValue);
            this.collector.collect(this.nextValue);
        }
    }

    @Override
    protected void callUserFunction() throws Exception {
        this.reduced = this.reducer.reduce(this.currentValue, this.nextValue);
    }
}

