/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.invokable.StreamInvokable;
import org.apache.flink.streaming.api.invokable.operator.WindowGroupReduceInvokable;
import org.apache.flink.streaming.api.invokable.operator.WindowInvokable;
import org.apache.flink.streaming.api.invokable.operator.WindowReduceInvokable;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.streaming.api.windowing.policy.ActiveEvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.ActiveTriggerCallback;
import org.apache.flink.streaming.api.windowing.policy.ActiveTriggerPolicy;
import org.apache.flink.streaming.api.windowing.policy.CloneableEvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.CloneableTriggerPolicy;
import org.apache.flink.streaming.api.windowing.policy.EvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.TriggerPolicy;

public class GroupedWindowInvokable<IN, OUT>
extends StreamInvokable<IN, OUT> {
    private static final long serialVersionUID = -3469545957144404137L;
    private KeySelector<IN, ?> keySelector;
    private Configuration parameters;
    private LinkedList<ActiveTriggerPolicy<IN>> activeCentralTriggerPolicies;
    private LinkedList<TriggerPolicy<IN>> centralTriggerPolicies;
    private LinkedList<ActiveEvictionPolicy<IN>> activeCentralEvictionPolicies;
    private LinkedList<EvictionPolicy<IN>> centralEvictionPolicies;
    private LinkedList<CloneableTriggerPolicy<IN>> distributedTriggerPolicies;
    private LinkedList<CloneableEvictionPolicy<IN>> distributedEvictionPolicies;
    private Map<Object, WindowInvokable<IN, OUT>> windowingGroups;
    private LinkedList<Thread> activePolicyThreads;
    private LinkedList<TriggerPolicy<IN>> currentTriggerPolicies;
    private LinkedList<WindowInvokable<IN, OUT>> deleteOrderForCentralEviction;

    public GroupedWindowInvokable(Function userFunction, KeySelector<IN, ?> keySelector, LinkedList<CloneableTriggerPolicy<IN>> distributedTriggerPolicies, LinkedList<CloneableEvictionPolicy<IN>> distributedEvictionPolicies, LinkedList<TriggerPolicy<IN>> centralTriggerPolicies, LinkedList<EvictionPolicy<IN>> centralEvictionPolicies) {
        super(userFunction);
        this.keySelector = keySelector;
        if (centralTriggerPolicies != null) {
            this.centralTriggerPolicies = centralTriggerPolicies;
            this.activeCentralTriggerPolicies = new LinkedList();
            for (TriggerPolicy triggerPolicy : centralTriggerPolicies) {
                if (!(triggerPolicy instanceof ActiveTriggerPolicy)) continue;
                this.activeCentralTriggerPolicies.add((ActiveTriggerPolicy)triggerPolicy);
            }
        } else {
            this.centralTriggerPolicies = new LinkedList();
        }
        this.distributedTriggerPolicies = distributedTriggerPolicies != null ? distributedTriggerPolicies : new LinkedList();
        this.distributedEvictionPolicies = distributedEvictionPolicies != null ? distributedEvictionPolicies : new LinkedList();
        this.activeCentralEvictionPolicies = new LinkedList();
        if (centralEvictionPolicies != null) {
            this.centralEvictionPolicies = centralEvictionPolicies;
            for (EvictionPolicy evictionPolicy : centralEvictionPolicies) {
                if (!(evictionPolicy instanceof ActiveEvictionPolicy)) continue;
                this.activeCentralEvictionPolicies.add((ActiveEvictionPolicy)evictionPolicy);
            }
        } else {
            this.centralEvictionPolicies = new LinkedList();
        }
        this.windowingGroups = new HashMap<Object, WindowInvokable<IN, OUT>>();
        this.activePolicyThreads = new LinkedList();
        this.currentTriggerPolicies = new LinkedList();
        this.deleteOrderForCentralEviction = new LinkedList();
        if (!this.centralEvictionPolicies.isEmpty() && !this.distributedEvictionPolicies.isEmpty()) {
            throw new UnsupportedOperationException("You can only use either central or distributed eviction policies but not both at the same time.");
        }
        if (this.centralEvictionPolicies.isEmpty() && this.distributedEvictionPolicies.isEmpty()) {
            throw new UnsupportedOperationException("You have to define at least one eviction policy");
        }
        if (this.centralTriggerPolicies.isEmpty() && this.distributedTriggerPolicies.isEmpty()) {
            throw new UnsupportedOperationException("You have to define at least one trigger policy");
        }
    }

    @Override
    public void invoke() throws Exception {
        if (this.readNext() == null) {
            throw new RuntimeException("DataStream must not be empty");
        }
        while (this.nextRecord != null) {
            WindowInvokable groupInvokable = this.windowingGroups.get(this.keySelector.getKey(this.nextRecord.getObject()));
            if (groupInvokable == null) {
                groupInvokable = this.makeNewGroup(this.nextRecord);
            }
            for (ActiveTriggerPolicy activeTriggerPolicy : this.activeCentralTriggerPolicies) {
                Object[] result;
                for (Object in : result = activeTriggerPolicy.preNotifyTrigger(this.nextRecord.getObject())) {
                    if (!this.activeCentralEvictionPolicies.isEmpty()) {
                        this.evictElements(this.centralActiveEviction(in));
                    }
                    for (WindowInvokable<IN, OUT> group : this.windowingGroups.values()) {
                        group.processFakeElement(in, activeTriggerPolicy);
                        this.checkForEmptyGroupBuffer(group);
                    }
                }
            }
            for (TriggerPolicy triggerPolicy : this.centralTriggerPolicies) {
                if (!triggerPolicy.notifyTrigger(this.nextRecord.getObject())) continue;
                this.currentTriggerPolicies.add(triggerPolicy);
            }
            if (this.currentTriggerPolicies.isEmpty()) {
                groupInvokable.processRealElement(this.nextRecord.getObject());
                this.checkForEmptyGroupBuffer(groupInvokable);
                if (!this.centralEvictionPolicies.isEmpty()) {
                    this.evictElements(this.centralEviction(this.nextRecord.getObject(), false));
                    this.deleteOrderForCentralEviction.add(groupInvokable);
                }
            } else {
                for (WindowInvokable windowInvokable : this.windowingGroups.values()) {
                    if (windowInvokable == groupInvokable) {
                        windowInvokable.processRealElement(this.nextRecord.getObject(), this.currentTriggerPolicies);
                        continue;
                    }
                    windowInvokable.externalTriggerFakeElement(this.nextRecord.getObject(), this.currentTriggerPolicies);
                }
                if (!this.centralEvictionPolicies.isEmpty()) {
                    this.evictElements(this.centralEviction(this.nextRecord.getObject(), true));
                    this.deleteOrderForCentralEviction.add(groupInvokable);
                }
            }
            this.currentTriggerPolicies.clear();
            this.readNext();
        }
        for (Thread thread : this.activePolicyThreads) {
            thread.interrupt();
        }
        for (WindowInvokable windowInvokable : this.windowingGroups.values()) {
            windowInvokable.emitFinalWindow(this.centralTriggerPolicies);
        }
    }

    private WindowInvokable<IN, OUT> makeNewGroup(StreamRecord<IN> element) throws Exception {
        LinkedList clonedDistributedTriggerPolicies = new LinkedList();
        LinkedList clonedDistributedEvictionPolicies = new LinkedList();
        for (CloneableTriggerPolicy cloneableTriggerPolicy : this.distributedTriggerPolicies) {
            clonedDistributedTriggerPolicies.add(cloneableTriggerPolicy.clone());
        }
        for (CloneableEvictionPolicy cloneableEvictionPolicy : this.distributedEvictionPolicies) {
            clonedDistributedEvictionPolicies.add(cloneableEvictionPolicy.clone());
        }
        WindowInvokable groupInvokable = this.userFunction instanceof ReduceFunction ? new WindowReduceInvokable((ReduceFunction)this.userFunction, clonedDistributedTriggerPolicies, clonedDistributedEvictionPolicies) : new WindowGroupReduceInvokable((GroupReduceFunction)this.userFunction, clonedDistributedTriggerPolicies, clonedDistributedEvictionPolicies);
        groupInvokable.setup(this.taskContext);
        groupInvokable.open(this.parameters);
        this.windowingGroups.put(this.keySelector.getKey(element.getObject()), groupInvokable);
        return groupInvokable;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.parameters = parameters;
        for (ActiveTriggerPolicy activeTriggerPolicy : this.activeCentralTriggerPolicies) {
            Runnable target = activeTriggerPolicy.createActiveTriggerRunnable(new WindowingCallback(activeTriggerPolicy));
            if (target == null) continue;
            Thread thread = new Thread(target);
            this.activePolicyThreads.add(thread);
            thread.start();
        }
    }

    private int centralEviction(IN input, boolean triggered) {
        int currentMaxEviction = 0;
        for (EvictionPolicy evictionPolicy : this.centralEvictionPolicies) {
            int tmp = evictionPolicy.notifyEviction(input, triggered, this.deleteOrderForCentralEviction.size());
            if (tmp <= currentMaxEviction) continue;
            currentMaxEviction = tmp;
        }
        return currentMaxEviction;
    }

    private int centralActiveEviction(Object input) {
        int currentMaxEviction = 0;
        for (ActiveEvictionPolicy activeEvictionPolicy : this.activeCentralEvictionPolicies) {
            int tmp = activeEvictionPolicy.notifyEvictionWithFakeElement(input, this.deleteOrderForCentralEviction.size());
            if (tmp <= currentMaxEviction) continue;
            currentMaxEviction = tmp;
        }
        return currentMaxEviction;
    }

    private void evictElements(int numToEvict) {
        HashSet<WindowInvokable<IN, OUT>> usedGroups = new HashSet<WindowInvokable<IN, OUT>>();
        while (numToEvict > 0) {
            WindowInvokable<IN, OUT> currentGroup = this.deleteOrderForCentralEviction.getFirst();
            currentGroup.evictFirst();
            usedGroups.add(currentGroup);
            try {
                this.deleteOrderForCentralEviction.removeFirst();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            --numToEvict;
        }
        for (WindowInvokable windowInvokable : usedGroups) {
            this.checkForEmptyGroupBuffer(windowInvokable);
        }
    }

    private void checkForEmptyGroupBuffer(WindowInvokable<IN, OUT> group) {
        if (group.isBufferEmpty()) {
            this.windowingGroups.remove(group);
        }
    }

    private class WindowingCallback
    implements ActiveTriggerCallback {
        private ActiveTriggerPolicy<IN> policy;

        public WindowingCallback(ActiveTriggerPolicy<IN> policy) {
            this.policy = policy;
        }

        @Override
        public void sendFakeElement(Object datapoint) {
            if (!GroupedWindowInvokable.this.centralEvictionPolicies.isEmpty()) {
                GroupedWindowInvokable.this.evictElements(GroupedWindowInvokable.this.centralActiveEviction(datapoint));
            }
            for (WindowInvokable group : GroupedWindowInvokable.this.windowingGroups.values()) {
                group.processFakeElement(datapoint, this.policy);
                GroupedWindowInvokable.this.checkForEmptyGroupBuffer(group);
            }
        }
    }
}

