/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.streaming.api.invokable.operator.WindowInvokable;
import org.apache.flink.streaming.api.windowing.policy.EvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.TriggerPolicy;

public class WindowReduceInvokable<IN>
extends WindowInvokable<IN, IN> {
    private static final long serialVersionUID = 1L;
    ReduceFunction<IN> reducer;

    public WindowReduceInvokable(ReduceFunction<IN> userFunction, LinkedList<TriggerPolicy<IN>> triggerPolicies, LinkedList<EvictionPolicy<IN>> evictionPolicies) {
        super((Function)userFunction, triggerPolicies, evictionPolicies);
        this.reducer = userFunction;
    }

    @Override
    protected void callUserFunction() throws Exception {
        Iterator reducedIterator = this.buffer.iterator();
        Object reduced = null;
        while (reducedIterator.hasNext() && reduced == null) {
            reduced = reducedIterator.next();
        }
        while (reducedIterator.hasNext()) {
            Object next = reducedIterator.next();
            if (next == null) continue;
            reduced = this.reducer.reduce(this.copy(reduced), this.copy(next));
        }
        if (reduced != null) {
            this.collector.collect(reduced);
        }
    }
}

