/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator.co;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.math.util.MathUtils;
import org.apache.flink.streaming.api.function.co.CoWindowFunction;
import org.apache.flink.streaming.api.invokable.operator.co.CoInvokable;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.streaming.api.windowing.helper.TimestampWrapper;
import org.apache.flink.streaming.state.CircularFifoList;

public class CoWindowInvokable<IN1, IN2, OUT>
extends CoInvokable<IN1, IN2, OUT> {
    private static final long serialVersionUID = 1L;
    protected CoWindowFunction<IN1, IN2, OUT> coWindowFunction;
    protected long windowSize;
    protected long slideSize;
    protected CircularFifoList<StreamRecord<IN1>> circularList1;
    protected CircularFifoList<StreamRecord<IN2>> circularList2;
    protected TimestampWrapper<IN1> timeStamp1;
    protected TimestampWrapper<IN2> timeStamp2;
    protected StreamWindow window;
    protected long startTime;
    protected long nextRecordTime;

    public CoWindowInvokable(CoWindowFunction<IN1, IN2, OUT> coWindowFunction, long windowSize, long slideInterval, TimestampWrapper<IN1> timeStamp1, TimestampWrapper<IN2> timeStamp2) {
        super(coWindowFunction);
        this.coWindowFunction = coWindowFunction;
        this.windowSize = windowSize;
        this.slideSize = slideInterval;
        this.circularList1 = new CircularFifoList();
        this.circularList2 = new CircularFifoList();
        this.timeStamp1 = timeStamp1;
        this.timeStamp2 = timeStamp2;
        this.startTime = timeStamp1.getStartTime();
        this.window = new StreamWindow();
    }

    @Override
    protected void handleStream1() throws Exception {
        this.window.addToBuffer1(this.reuse1.getObject());
    }

    @Override
    protected void handleStream2() throws Exception {
        this.window.addToBuffer2(this.reuse2.getObject());
    }

    @Override
    protected void callUserFunction() throws Exception {
        ArrayList<Object> first = new ArrayList<Object>();
        ArrayList<Object> second = new ArrayList<Object>();
        for (Object element : this.window.circularList1.getElements()) {
            first.add(this.serializer1.copy(element));
        }
        for (Object element : this.window.circularList2.getElements()) {
            second.add(this.serializer2.copy(element));
        }
        if (!this.window.circularList1.isEmpty() || !this.window.circularList2.isEmpty()) {
            this.coWindowFunction.coWindow(first, second, this.collector);
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.window.miniBatchEnd()) {
            this.callUserFunctionAndLogException();
        }
        super.close();
    }

    @Override
    protected void callUserFunction1() throws Exception {
    }

    @Override
    protected void callUserFunction2() throws Exception {
    }

    public void setSlideSize(long slideSize) {
        this.slideSize = slideSize;
    }

    protected class StreamWindow
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected int granularity;
        protected int batchPerSlide;
        protected long numberOfBatches;
        protected long minibatchCounter;
        protected CircularFifoList<IN1> circularList1;
        protected CircularFifoList<IN2> circularList2;

        public StreamWindow() {
            this.granularity = (int)MathUtils.gcd((long)CoWindowInvokable.this.windowSize, (long)CoWindowInvokable.this.slideSize);
            this.batchPerSlide = (int)(CoWindowInvokable.this.slideSize / (long)this.granularity);
            this.numberOfBatches = CoWindowInvokable.this.windowSize / (long)this.granularity;
            this.circularList1 = new CircularFifoList();
            this.circularList2 = new CircularFifoList();
            this.minibatchCounter = 0L;
        }

        public void addToBuffer1(IN1 nextValue) throws Exception {
            this.checkWindowEnd(CoWindowInvokable.this.timeStamp1.getTimestamp(nextValue));
            if (this.minibatchCounter >= 0L) {
                this.circularList1.add(nextValue);
            }
        }

        public void addToBuffer2(IN2 nextValue) throws Exception {
            this.checkWindowEnd(CoWindowInvokable.this.timeStamp2.getTimestamp(nextValue));
            if (this.minibatchCounter >= 0L) {
                this.circularList2.add(nextValue);
            }
        }

        protected synchronized void checkWindowEnd(long timeStamp) {
            CoWindowInvokable.this.nextRecordTime = timeStamp;
            while (this.miniBatchEnd()) {
                this.circularList1.newSlide();
                this.circularList2.newSlide();
                ++this.minibatchCounter;
                if (!this.windowEnd()) continue;
                CoWindowInvokable.this.callUserFunctionAndLogException();
                this.circularList1.shiftWindow(this.batchPerSlide);
                this.circularList2.shiftWindow(this.batchPerSlide);
            }
        }

        protected boolean miniBatchEnd() {
            if (CoWindowInvokable.this.nextRecordTime < CoWindowInvokable.this.startTime + (long)this.granularity) {
                return false;
            }
            CoWindowInvokable.this.startTime += (long)this.granularity;
            return true;
        }

        public boolean windowEnd() {
            if (this.minibatchCounter == this.numberOfBatches) {
                this.minibatchCounter -= (long)this.batchPerSlide;
                return true;
            }
            return false;
        }

        public void reduceLastBatch() {
            if (!this.miniBatchEnd()) {
                CoWindowInvokable.this.callUserFunctionAndLogException();
            }
        }

        public Iterable<IN1> getIterable1() {
            return this.circularList1.getIterable();
        }

        public Iterable<IN2> getIterable2() {
            return this.circularList2.getIterable();
        }

        public String toString() {
            return this.circularList1.toString();
        }
    }
}

