/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.streamrecord;

import java.io.Serializable;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.streaming.api.streamrecord.UID;

public class StreamRecord<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UID uid = new UID();
    private T streamObject;
    public boolean isTuple;

    public UID getId() {
        return this.uid;
    }

    public StreamRecord<T> newId(int channelID) {
        this.uid = new UID(channelID);
        return this;
    }

    public void setId(UID id) {
        this.uid = id;
    }

    public T getObject() {
        return this.streamObject;
    }

    public Object getField(int pos) {
        if (this.isTuple) {
            return ((Tuple)this.streamObject).getField(pos);
        }
        if (pos == 0) {
            return this.streamObject;
        }
        throw new IndexOutOfBoundsException();
    }

    public <R> R getKey(KeySelector<T, R> keySelector) {
        try {
            return (R)keySelector.getKey(this.streamObject);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to extract key: " + e.getMessage());
        }
    }

    public StreamRecord<T> setObject(T object) {
        this.streamObject = object;
        return this;
    }

    public String toString() {
        return this.streamObject.toString();
    }
}

