/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.streamrecord;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;

public final class StreamRecordSerializer<T>
extends TypeSerializer<StreamRecord<T>> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> typeSerializer;
    private final boolean isTuple;

    public StreamRecordSerializer(TypeInformation<T> typeInfo) {
        this.typeSerializer = typeInfo.createSerializer();
        this.isTuple = typeInfo.isTupleType();
    }

    public TypeSerializer<T> getObjectSerializer() {
        return this.typeSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public boolean isStateful() {
        return false;
    }

    public StreamRecord<T> createInstance() {
        try {
            StreamRecord<Object> t = new StreamRecord<Object>();
            t.isTuple = this.isTuple;
            t.setObject(this.typeSerializer.createInstance());
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate StreamRecord.", e);
        }
    }

    public StreamRecord<T> copy(StreamRecord<T> from) {
        StreamRecord<Object> rec = new StreamRecord<Object>();
        rec.isTuple = from.isTuple;
        rec.setId(from.getId().copy());
        rec.setObject(this.typeSerializer.copy(from.getObject()));
        return rec;
    }

    public StreamRecord<T> copy(StreamRecord<T> from, StreamRecord<T> reuse) {
        reuse.isTuple = from.isTuple;
        reuse.setId(from.getId().copy());
        reuse.setObject(this.typeSerializer.copy(from.getObject(), reuse.getObject()));
        return reuse;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(StreamRecord<T> value, DataOutputView target) throws IOException {
        value.getId().write(target);
        this.typeSerializer.serialize(value.getObject(), target);
    }

    public StreamRecord<T> deserialize(DataInputView source) throws IOException {
        StreamRecord<Object> record = new StreamRecord<Object>();
        record.isTuple = this.isTuple;
        record.getId().read(source);
        record.setObject(this.typeSerializer.deserialize(source));
        return record;
    }

    public StreamRecord<T> deserialize(StreamRecord<T> reuse, DataInputView source) throws IOException {
        reuse.getId().read(source);
        reuse.setObject(this.typeSerializer.deserialize(reuse.getObject(), source));
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
    }
}

