/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.streamrecord;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class UID
implements IOReadableWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    private ByteBuffer uid;
    private static Random random = new Random();

    public UID() {
        this.uid = ByteBuffer.allocate(20);
    }

    public UID(int channelID) {
        byte[] uuid = new byte[16];
        random.nextBytes(uuid);
        this.uid = ByteBuffer.allocate(20).putInt(channelID).put(uuid);
    }

    UID(byte[] id) {
        this.uid = ByteBuffer.wrap(id);
    }

    public int getChannelId() {
        this.uid.position(0);
        return this.uid.getInt();
    }

    public byte[] getGeneratedId() {
        this.uid.position(4);
        return this.uid.slice().array();
    }

    public byte[] getId() {
        this.uid.position(0);
        return this.uid.array();
    }

    public void write(DataOutputView out) throws IOException {
        out.write(this.uid.array());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.write(this.uid.array());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        byte[] uidA = new byte[20];
        stream.read(uidA);
        this.uid = ByteBuffer.allocate(20).put(uidA);
    }

    public void read(DataInputView in) throws IOException {
        byte[] uidByteArray = new byte[20];
        in.readFully(uidByteArray, 0, 20);
        this.uid = ByteBuffer.wrap(uidByteArray);
    }

    public String toString() {
        return this.getChannelId() + "-" + Long.toHexString(this.uid.getLong(4)) + "-" + Long.toHexString(this.uid.getLong(12));
    }

    public int hashCode() {
        return Arrays.hashCode(this.getId());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            UID other = (UID)obj;
            return Arrays.equals(this.getId(), other.getId());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public UID copy() {
        return new UID(Arrays.copyOf(this.uid.array(), 20));
    }
}

