/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.streamvertex;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.MutableReader;
import org.apache.flink.runtime.io.network.api.MutableRecordReader;
import org.apache.flink.runtime.io.network.api.MutableUnionRecordReader;
import org.apache.flink.runtime.operators.util.ReaderIterator;
import org.apache.flink.streaming.api.StreamConfig;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.streaming.api.streamrecord.StreamRecordSerializer;
import org.apache.flink.streaming.api.streamvertex.StreamVertex;
import org.apache.flink.streaming.api.streamvertex.StreamVertexException;
import org.apache.flink.util.MutableObjectIterator;

public class InputHandler<IN> {
    private StreamRecordSerializer<IN> inputSerializer = null;
    private MutableObjectIterator<StreamRecord<IN>> inputIter;
    private MutableReader<IOReadableWritable> inputs;
    private StreamVertex<IN, ?> streamVertex;
    private StreamConfig configuration;

    public InputHandler(StreamVertex<IN, ?> streamComponent) {
        this.streamVertex = streamComponent;
        this.configuration = new StreamConfig(streamComponent.getTaskConfiguration());
        try {
            this.setConfigInputs();
        }
        catch (Exception e) {
            throw new StreamVertexException("Cannot register inputs for " + this.getClass().getSimpleName(), e);
        }
    }

    protected void setConfigInputs() throws StreamVertexException {
        this.inputSerializer = this.configuration.getTypeSerializerIn1(this.streamVertex.userClassLoader);
        int numberOfInputs = this.configuration.getNumberOfInputs();
        if (numberOfInputs > 0) {
            if (numberOfInputs < 2) {
                this.inputs = new MutableRecordReader(this.streamVertex);
            } else {
                MutableRecordReader[] recordReaders = new MutableRecordReader[numberOfInputs];
                for (int i = 0; i < numberOfInputs; ++i) {
                    recordReaders[i] = new MutableRecordReader(this.streamVertex);
                }
                this.inputs = new MutableUnionRecordReader(recordReaders);
            }
            this.inputIter = this.createInputIterator();
        }
    }

    private MutableObjectIterator<StreamRecord<IN>> createInputIterator() {
        ReaderIterator iter = new ReaderIterator(this.inputs, this.inputSerializer);
        return iter;
    }

    protected static <T> MutableObjectIterator<StreamRecord<T>> staticCreateInputIterator(MutableReader<?> inputReader, TypeSerializer<?> serializer) {
        MutableReader<?> reader = inputReader;
        ReaderIterator iter = new ReaderIterator(reader, serializer);
        return iter;
    }

    public StreamRecordSerializer<IN> getInputSerializer() {
        return this.inputSerializer;
    }

    public MutableObjectIterator<StreamRecord<IN>> getInputIter() {
        return this.inputIter;
    }
}

