/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.streamvertex;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.runtime.io.network.api.RecordWriter;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.api.StreamConfig;
import org.apache.flink.streaming.api.collector.DirectedStreamCollector;
import org.apache.flink.streaming.api.collector.OutputSelector;
import org.apache.flink.streaming.api.collector.StreamCollector;
import org.apache.flink.streaming.api.invokable.StreamInvokable;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.streaming.api.streamrecord.StreamRecordSerializer;
import org.apache.flink.streaming.api.streamvertex.StreamVertex;
import org.apache.flink.streaming.api.streamvertex.StreamVertexException;
import org.apache.flink.streaming.io.StreamRecordWriter;
import org.apache.flink.streaming.partitioner.StreamPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputHandler<OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(OutputHandler.class);
    private StreamVertex<?, OUT> streamVertex;
    private StreamConfig configuration;
    private List<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>> outputs;
    private StreamCollector<OUT> collector;
    private long bufferTimeout;
    TypeInformation<OUT> outTypeInfo = null;
    StreamRecordSerializer<OUT> outSerializer = null;
    SerializationDelegate<StreamRecord<OUT>> outSerializationDelegate = null;
    long startTime;

    public OutputHandler(StreamVertex<?, OUT> streamComponent) {
        this.streamVertex = streamComponent;
        this.outputs = new LinkedList<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>>();
        this.configuration = new StreamConfig(streamComponent.getTaskConfiguration());
        try {
            this.setConfigOutputs();
        }
        catch (StreamVertexException e) {
            throw new StreamVertexException("Cannot register outputs for " + streamComponent.getClass().getSimpleName(), e);
        }
    }

    public List<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>> getOutputs() {
        return this.outputs;
    }

    private void setConfigOutputs() {
        this.setSerializers();
        this.setCollector();
        int numberOfOutputs = this.configuration.getNumberOfOutputs();
        this.bufferTimeout = this.configuration.getBufferTimeout();
        for (int i = 0; i < numberOfOutputs; ++i) {
            this.setPartitioner(i, this.outputs);
        }
    }

    private StreamCollector<OUT> setCollector() {
        if (this.streamVertex.configuration.getDirectedEmit()) {
            OutputSelector outputSelector = this.streamVertex.configuration.getOutputSelector(this.streamVertex.userClassLoader);
            this.collector = new DirectedStreamCollector<OUT>(this.streamVertex.getInstanceID(), this.outSerializationDelegate, outputSelector);
        } else {
            this.collector = new StreamCollector<OUT>(this.streamVertex.getInstanceID(), this.outSerializationDelegate);
        }
        return this.collector;
    }

    public StreamCollector<OUT> getCollector() {
        return this.collector;
    }

    void setSerializers() {
        this.outSerializer = this.configuration.getTypeSerializerOut1(this.streamVertex.userClassLoader);
        if (this.outSerializer != null) {
            this.outSerializationDelegate = new SerializationDelegate(this.outSerializer);
            this.outSerializationDelegate.setInstance(this.outSerializer.createInstance());
        }
    }

    void setPartitioner(int outputNumber, List<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>> outputs) {
        StreamRecordWriter output;
        StreamPartitioner outputPartitioner = null;
        try {
            outputPartitioner = this.configuration.getPartitioner(this.streamVertex.userClassLoader, outputNumber);
        }
        catch (Exception e) {
            throw new StreamVertexException("Cannot deserialize partitioner for " + this.streamVertex.getName() + " with " + outputNumber + " outputs", e);
        }
        if (this.bufferTimeout >= 0L) {
            output = new StreamRecordWriter(this.streamVertex, outputPartitioner, this.bufferTimeout);
            if (LOG.isTraceEnabled()) {
                LOG.trace("StreamRecordWriter initiated with {} bufferTimeout for {}", (Object)this.bufferTimeout, (Object)this.streamVertex.getClass().getSimpleName());
            }
        } else {
            output = new StreamRecordWriter(this.streamVertex, outputPartitioner);
            if (LOG.isTraceEnabled()) {
                LOG.trace("RecordWriter initiated for {}", (Object)this.streamVertex.getClass().getSimpleName());
            }
        }
        outputs.add(output);
        List<String> outputName = this.configuration.getOutputName(outputNumber);
        boolean isSelectAllOutput = this.configuration.getSelectAll(outputNumber);
        if (this.collector != null) {
            this.collector.addOutput(output, outputName, isSelectAllOutput);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Partitioner set: {} with {} outputs for {}", new Object[]{outputPartitioner.getClass().getSimpleName(), outputNumber, this.streamVertex.getClass().getSimpleName()});
        }
    }

    public void flushOutputs() throws IOException, InterruptedException {
        for (RecordWriter<SerializationDelegate<StreamRecord<OUT>>> output : this.outputs) {
            if (output instanceof StreamRecordWriter) {
                ((StreamRecordWriter)output).close();
                continue;
            }
            output.flush();
        }
    }

    public void initializeOutputSerializers() {
        for (RecordWriter<SerializationDelegate<StreamRecord<OUT>>> output : this.outputs) {
            output.initializeSerializers();
        }
    }

    public void invokeUserFunction(String componentTypeName, StreamInvokable<?, OUT> userInvokable) throws IOException, InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} invoked with instance id {}", new Object[]{componentTypeName, this.streamVertex.getName(), this.streamVertex.getInstanceID()});
        }
        this.initializeOutputSerializers();
        try {
            this.streamVertex.invokeUserFunction(userInvokable);
        }
        catch (Exception e) {
            this.flushOutputs();
            throw new RuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} invoke finished instance id {}", new Object[]{componentTypeName, this.streamVertex.getName(), this.streamVertex.getInstanceID()});
        }
        this.flushOutputs();
    }
}

