/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.streamvertex;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.runtime.io.network.api.RecordWriter;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.streaming.api.streamvertex.OutputHandler;
import org.apache.flink.streaming.api.streamvertex.StreamVertex;
import org.apache.flink.streaming.io.BlockingQueueBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamIterationHead<OUT extends Tuple>
extends StreamVertex<OUT, OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamIterationHead.class);
    private OutputHandler<OUT> outputHandler;
    private static int numSources;
    private Integer iterationId;
    private BlockingQueue<StreamRecord> dataChannel;
    private long iterationWaitTime;
    private boolean shouldWait;

    public StreamIterationHead() {
        this.instanceID = numSources = StreamIterationHead.newVertex();
        this.dataChannel = new ArrayBlockingQueue<StreamRecord>(1);
    }

    @Override
    public void setInputsOutputs() {
        this.outputHandler = new OutputHandler(this);
        this.iterationId = this.configuration.getIterationId();
        this.iterationWaitTime = this.configuration.getIterationWaitTime();
        this.shouldWait = this.iterationWaitTime > 0L;
        try {
            BlockingQueueBroker.instance().handIn(this.iterationId.toString(), this.dataChannel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void invoke() throws Exception {
        StreamRecord nextRecord;
        if (LOG.isDebugEnabled()) {
            LOG.debug("SOURCE {} invoked with instance id {}", (Object)this.getName(), (Object)this.getInstanceID());
        }
        this.outputHandler.initializeOutputSerializers();
        while ((nextRecord = this.shouldWait ? this.dataChannel.poll(this.iterationWaitTime, TimeUnit.MILLISECONDS) : this.dataChannel.take()) != null) {
            for (RecordWriter<SerializationDelegate<StreamRecord<OUT>>> output : this.outputHandler.getOutputs()) {
                this.outputHandler.outSerializationDelegate.setInstance((Object)nextRecord);
                output.emit(this.outputHandler.outSerializationDelegate);
            }
        }
        this.outputHandler.flushOutputs();
    }

    @Override
    protected void setInvokable() {
    }
}

