/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.streamvertex;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.streaming.api.streamvertex.InputHandler;
import org.apache.flink.streaming.api.streamvertex.StreamVertex;
import org.apache.flink.streaming.api.streamvertex.StreamVertexException;
import org.apache.flink.streaming.io.BlockingQueueBroker;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamIterationTail<IN extends Tuple>
extends StreamVertex<IN, IN> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamIterationTail.class);
    private InputHandler<IN> inputHandler;
    private Integer iterationId;
    private BlockingQueue<StreamRecord> dataChannel;
    private long iterationWaitTime;
    private boolean shouldWait;

    @Override
    public void setInputsOutputs() {
        try {
            this.inputHandler = new InputHandler(this);
            this.iterationId = this.configuration.getIterationId();
            this.iterationWaitTime = this.configuration.getIterationWaitTime();
            this.shouldWait = this.iterationWaitTime > 0L;
            this.dataChannel = (BlockingQueue)BlockingQueueBroker.instance().get(this.iterationId.toString());
        }
        catch (Exception e) {
            throw new StreamVertexException(String.format("Cannot register inputs of StreamIterationSink %s", this.iterationId), e);
        }
    }

    @Override
    public void invoke() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SINK {} invoked", (Object)this.getName());
        }
        this.forwardRecords();
        if (LOG.isDebugEnabled()) {
            LOG.debug("SINK {} invoke finished", (Object)this.getName());
        }
    }

    protected void forwardRecords() throws Exception {
        Object reuse = this.inputHandler.getInputSerializer().createInstance();
        while ((reuse = (StreamRecord)this.inputHandler.getInputIter().next(reuse)) != null && this.pushToQueue((StreamRecord<IN>)reuse)) {
            reuse = this.inputHandler.getInputSerializer().createInstance();
        }
    }

    private boolean pushToQueue(StreamRecord<IN> record) {
        try {
            if (this.shouldWait) {
                return this.dataChannel.offer(record, this.iterationWaitTime, TimeUnit.MILLISECONDS);
            }
            this.dataChannel.put(record);
            return true;
        }
        catch (InterruptedException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Pushing back record at iteration %s failed due to: {}", (Object)this.iterationId, (Object)StringUtils.stringifyException((Throwable)e));
            }
            return false;
        }
    }

    @Override
    protected void setInvokable() {
    }
}

