/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.streamvertex;

import java.util.Map;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.streaming.api.StreamConfig;
import org.apache.flink.streaming.api.invokable.StreamInvokable;
import org.apache.flink.streaming.api.streamrecord.StreamRecordSerializer;
import org.apache.flink.streaming.api.streamvertex.InputHandler;
import org.apache.flink.streaming.api.streamvertex.OutputHandler;
import org.apache.flink.streaming.api.streamvertex.StreamTaskContext;
import org.apache.flink.streaming.api.streamvertex.StreamingRuntimeContext;
import org.apache.flink.streaming.io.CoReaderIterator;
import org.apache.flink.streaming.state.OperatorState;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public class StreamVertex<IN, OUT>
extends AbstractInvokable
implements StreamTaskContext<OUT> {
    private static int numTasks;
    protected StreamConfig configuration;
    protected int instanceID = numTasks = StreamVertex.newVertex();
    protected String name;
    private static int numVertices;
    protected String functionName;
    private InputHandler<IN> inputHandler;
    protected OutputHandler<OUT> outputHandler;
    private StreamInvokable<IN, OUT> userInvokable = null;
    private StreamingRuntimeContext context;
    private Map<String, OperatorState<?>> states;
    protected ClassLoader userClassLoader;

    protected static int newVertex() {
        return ++numVertices;
    }

    public void registerInputOutput() {
        this.initialize();
        this.setInputsOutputs();
        this.setInvokable();
    }

    protected void initialize() {
        this.userClassLoader = this.getUserCodeClassLoader();
        this.configuration = new StreamConfig(this.getTaskConfiguration());
        this.name = this.configuration.getVertexName();
        this.functionName = this.configuration.getFunctionName();
        this.states = this.configuration.getOperatorStates(this.userClassLoader);
        this.context = this.createRuntimeContext(this.name, this.states);
    }

    protected <T> void invokeUserFunction(StreamInvokable<?, T> userInvokable) throws Exception {
        userInvokable.setRuntimeContext((RuntimeContext)this.context);
        userInvokable.open(this.getTaskConfiguration());
        userInvokable.invoke();
        userInvokable.close();
    }

    public void setInputsOutputs() {
        this.inputHandler = new InputHandler(this);
        this.outputHandler = new OutputHandler(this);
    }

    protected void setInvokable() {
        this.userInvokable = (StreamInvokable)this.configuration.getUserInvokable(this.userClassLoader);
        this.userInvokable.setup(this);
    }

    public String getName() {
        return this.name;
    }

    public int getInstanceID() {
        return this.instanceID;
    }

    public StreamingRuntimeContext createRuntimeContext(String taskName, Map<String, OperatorState<?>> states) {
        Environment env = this.getEnvironment();
        return new StreamingRuntimeContext(taskName, env, this.getUserCodeClassLoader(), states);
    }

    public void invoke() throws Exception {
        this.outputHandler.invokeUserFunction("TASK", this.userInvokable);
    }

    @Override
    public StreamConfig getConfig() {
        return this.configuration;
    }

    @Override
    public <X> MutableObjectIterator<X> getInput(int index) {
        if (index == 0) {
            return this.inputHandler.getInputIter();
        }
        throw new IllegalArgumentException("There is only 1 input");
    }

    @Override
    public <X> StreamRecordSerializer<X> getInputSerializer(int index) {
        if (index == 0) {
            return this.inputHandler.getInputSerializer();
        }
        throw new IllegalArgumentException("There is only 1 input");
    }

    @Override
    public Collector<OUT> getOutputCollector() {
        return this.outputHandler.getCollector();
    }

    @Override
    public <X, Y> CoReaderIterator<X, Y> getCoReader() {
        throw new IllegalArgumentException("CoReader not available");
    }

    static {
        numVertices = 0;
    }
}

