/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.streamvertex;

import java.util.Map;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.streaming.state.OperatorState;

public class StreamingRuntimeContext
extends RuntimeUDFContext {
    public Environment env;
    private final Map<String, OperatorState<?>> operatorStates;

    public StreamingRuntimeContext(String name, Environment env, ClassLoader userCodeClassLoader, Map<String, OperatorState<?>> operatorStates) {
        super(name, env.getCurrentNumberOfSubtasks(), env.getIndexInSubtaskGroup(), userCodeClassLoader, env.getCopyTask());
        this.env = env;
        this.operatorStates = operatorStates;
    }

    public OperatorState<?> getState(String name) {
        if (this.operatorStates == null) {
            throw new RuntimeException("No state has been registered for this operator.");
        }
        OperatorState<?> state = this.operatorStates.get(name);
        if (state != null) {
            return state;
        }
        throw new RuntimeException("No state has been registered for the name: " + name);
    }

    public InputSplitProvider getInputSplitProvider() {
        return this.env.getInputSplitProvider();
    }

    public Configuration getTaskStubParameters() {
        return new TaskConfig(this.env.getTaskConfiguration()).getStubParameters();
    }
}

