/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.helper;

import org.apache.flink.streaming.api.windowing.helper.WindowingHelper;
import org.apache.flink.streaming.api.windowing.policy.CountEvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.CountTriggerPolicy;
import org.apache.flink.streaming.api.windowing.policy.EvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.TriggerPolicy;

public class Count
implements WindowingHelper {
    private int count;
    private int deleteOnEviction = 1;
    private int startValue = 0;

    public Count(int count) {
        this.count = count;
    }

    public EvictionPolicy<?> toEvict() {
        return new CountEvictionPolicy(this.count, this.deleteOnEviction);
    }

    public TriggerPolicy<?> toTrigger() {
        return new CountTriggerPolicy(this.count, this.startValue);
    }

    public Count withDelete(int deleteOnEviction) {
        this.deleteOnEviction = deleteOnEviction;
        return this;
    }

    public Count startingAt(int startValue) {
        this.startValue = startValue;
        return this;
    }

    public static Count of(int count) {
        return new Count(count);
    }
}

