/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.helper;

import java.util.concurrent.TimeUnit;
import org.apache.flink.streaming.api.windowing.helper.SystemTimestamp;
import org.apache.flink.streaming.api.windowing.helper.Timestamp;
import org.apache.flink.streaming.api.windowing.helper.TimestampWrapper;
import org.apache.flink.streaming.api.windowing.helper.WindowingHelper;
import org.apache.flink.streaming.api.windowing.policy.EvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.TimeEvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.TimeTriggerPolicy;
import org.apache.flink.streaming.api.windowing.policy.TriggerPolicy;

public class Time<DATA>
implements WindowingHelper<DATA> {
    protected long length;
    protected TimeUnit granularity;
    protected TimestampWrapper<DATA> timestampWrapper;
    protected long delay;

    private Time(long length, TimeUnit timeUnit, Timestamp<DATA> timestamp, long startTime) {
        this(length, timeUnit, new TimestampWrapper<DATA>(timestamp, startTime));
    }

    private Time(long length, TimeUnit timeUnit, TimestampWrapper<DATA> timestampWrapper) {
        this.length = length;
        this.granularity = timeUnit;
        this.timestampWrapper = timestampWrapper;
        this.delay = 0L;
    }

    @Override
    public EvictionPolicy<DATA> toEvict() {
        return new TimeEvictionPolicy<DATA>(this.granularityInMillis(), this.timestampWrapper);
    }

    @Override
    public TriggerPolicy<DATA> toTrigger() {
        return new TimeTriggerPolicy<DATA>(this.granularityInMillis(), this.timestampWrapper, this.delay);
    }

    public static <DATA> Time<DATA> of(long length, TimeUnit timeUnit) {
        return new Time(length, timeUnit, SystemTimestamp.getWrapper());
    }

    public static <DATA> Time<DATA> of(long length, Timestamp<DATA> timestamp, long startTime) {
        return new Time<DATA>(length, null, timestamp, startTime);
    }

    public static <DATA> Time<DATA> of(long length, Timestamp<DATA> timestamp) {
        return Time.of(length, timestamp, 0L);
    }

    public Time<DATA> withDelay(long delay) {
        this.delay = delay;
        return this;
    }

    protected long granularityInMillis() {
        return this.granularity == null ? this.length : this.granularity.toMillis(this.length);
    }
}

