/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.policy;

import org.apache.flink.streaming.api.windowing.policy.CloneableEvictionPolicy;

public class CountEvictionPolicy<IN>
implements CloneableEvictionPolicy<IN> {
    private static final long serialVersionUID = 2319201348806427996L;
    int maxElements;
    int counter;
    int deleteOnEviction = 1;

    public CountEvictionPolicy(int maxElements) {
        this(maxElements, 1);
    }

    public CountEvictionPolicy(int maxElements, int deleteOnEviction) {
        this(maxElements, deleteOnEviction, 0);
    }

    public CountEvictionPolicy(int maxElements, int deleteOnEviction, int startValue) {
        this.counter = startValue;
        this.deleteOnEviction = deleteOnEviction;
        this.maxElements = maxElements;
    }

    @Override
    public int notifyEviction(IN datapoint, boolean triggered, int bufferSize) {
        if (this.counter >= this.maxElements) {
            this.counter = this.counter - this.deleteOnEviction < 0 ? 0 : this.counter - this.deleteOnEviction;
            ++this.counter;
            return this.deleteOnEviction;
        }
        ++this.counter;
        return 0;
    }

    @Override
    public CountEvictionPolicy<IN> clone() {
        return new CountEvictionPolicy<IN>(this.maxElements, this.deleteOnEviction, this.counter);
    }
}

