/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.policy;

import org.apache.flink.streaming.api.windowing.policy.CloneableTriggerPolicy;

public class CountTriggerPolicy<IN>
implements CloneableTriggerPolicy<IN> {
    private static final long serialVersionUID = -6357200688886103968L;
    public static final int DEFAULT_START_VALUE = 0;
    private int counter;
    private int max;

    public CountTriggerPolicy(int max) {
        this(max, 0);
    }

    public CountTriggerPolicy(int max, int startValue) {
        this.max = max;
        this.counter = startValue;
    }

    @Override
    public boolean notifyTrigger(IN datapoint) {
        if (this.counter >= this.max) {
            this.counter = 1;
            return true;
        }
        ++this.counter;
        return false;
    }

    @Override
    public CountTriggerPolicy<IN> clone() {
        return new CountTriggerPolicy<IN>(this.max, this.counter);
    }
}

