/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.policy;

import java.util.LinkedList;
import java.util.List;
import org.apache.flink.streaming.api.windowing.deltafunction.DeltaFunction;
import org.apache.flink.streaming.api.windowing.policy.CloneableEvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.CloneableTriggerPolicy;

public class DeltaPolicy<DATA>
implements CloneableTriggerPolicy<DATA>,
CloneableEvictionPolicy<DATA> {
    private static final long serialVersionUID = -7797538922123394967L;
    private DeltaFunction<DATA> deltaFuntion;
    private List<DATA> windowBuffer;
    private double threshold;
    private DATA triggerDataPoint;

    public DeltaPolicy(DeltaFunction<DATA> deltaFuntion, DATA init, double threshold) {
        this.deltaFuntion = deltaFuntion;
        this.triggerDataPoint = init;
        this.windowBuffer = new LinkedList<DATA>();
        this.threshold = threshold;
    }

    @Override
    public boolean notifyTrigger(DATA datapoint) {
        if (this.deltaFuntion.getDelta(this.triggerDataPoint, datapoint) > this.threshold) {
            this.triggerDataPoint = datapoint;
            return true;
        }
        return false;
    }

    @Override
    public int notifyEviction(DATA datapoint, boolean triggered, int bufferSize) {
        this.windowBuffer = this.windowBuffer.subList(this.windowBuffer.size() - bufferSize, bufferSize);
        int evictCount = 0;
        for (DATA bufferPoint : this.windowBuffer) {
            if (this.deltaFuntion.getDelta(bufferPoint, datapoint) < this.threshold) break;
            ++evictCount;
        }
        if (evictCount > 0) {
            this.windowBuffer = this.windowBuffer.subList(evictCount, this.windowBuffer.size());
        }
        this.windowBuffer.add(datapoint);
        return evictCount;
    }

    @Override
    public DeltaPolicy<DATA> clone() {
        return new DeltaPolicy<DATA>(this.deltaFuntion, this.triggerDataPoint, this.threshold);
    }
}

