/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.policy;

import org.apache.flink.streaming.api.windowing.extractor.Extractor;
import org.apache.flink.streaming.api.windowing.policy.CloneableEvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.CloneableTriggerPolicy;

public class PunctuationPolicy<IN, DATA>
implements CloneableTriggerPolicy<IN>,
CloneableEvictionPolicy<IN> {
    private static final long serialVersionUID = -8845130188912602498L;
    private int counter = 0;
    private Extractor<IN, DATA> extractor;
    private DATA punctuation;

    public PunctuationPolicy(DATA punctuation) {
        this(punctuation, null);
    }

    public PunctuationPolicy(DATA punctuation, Extractor<IN, DATA> extractor) {
        this.punctuation = punctuation;
        this.extractor = extractor;
    }

    @Override
    public int notifyEviction(IN datapoint, boolean triggered, int bufferSize) {
        if (this.notifyTrigger(datapoint)) {
            int tmp = this.counter;
            this.counter = 1;
            return tmp;
        }
        ++this.counter;
        return 0;
    }

    @Override
    public boolean notifyTrigger(IN datapoint) {
        Object tmp = this.extractor == null ? datapoint : this.extractor.extract(datapoint);
        return this.punctuation.equals(tmp);
    }

    public PunctuationPolicy<IN, DATA> clone() {
        return new PunctuationPolicy<IN, DATA>(this.punctuation, this.extractor);
    }
}

