/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.policy;

import java.util.LinkedList;
import org.apache.flink.streaming.api.windowing.helper.TimestampWrapper;
import org.apache.flink.streaming.api.windowing.policy.ActiveEvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.CloneableEvictionPolicy;

public class TimeEvictionPolicy<DATA>
implements ActiveEvictionPolicy<DATA>,
CloneableEvictionPolicy<DATA> {
    private static final long serialVersionUID = -1457476766124518220L;
    private long granularity;
    private TimestampWrapper<DATA> timestampWrapper;
    private LinkedList<Long> buffer = new LinkedList();

    public TimeEvictionPolicy(long granularity, TimestampWrapper<DATA> timestampWrapper) {
        this.timestampWrapper = timestampWrapper;
        this.granularity = granularity;
    }

    @Override
    public int notifyEvictionWithFakeElement(Object datapoint, int bufferSize) {
        long threshold;
        this.checkForDeleted(bufferSize);
        try {
            threshold = (Long)datapoint - this.granularity;
        }
        catch (ClassCastException e) {
            threshold = this.timestampWrapper.getTimestamp(datapoint) - this.granularity;
        }
        return this.deleteAndCountExpired(threshold);
    }

    @Override
    public int notifyEviction(DATA datapoint, boolean triggered, int bufferSize) {
        this.checkForDeleted(bufferSize);
        long time = this.timestampWrapper.getTimestamp(datapoint);
        long threshold = time - this.granularity;
        int counter = this.deleteAndCountExpired(threshold);
        this.buffer.add(time);
        return counter;
    }

    private void checkForDeleted(int bufferSize) {
        while (bufferSize < this.buffer.size()) {
            this.buffer.removeFirst();
        }
    }

    private int deleteAndCountExpired(long threshold) {
        int counter = 0;
        while (!this.buffer.isEmpty() && this.buffer.getFirst() <= threshold) {
            this.buffer.removeFirst();
            ++counter;
        }
        return counter;
    }

    @Override
    public TimeEvictionPolicy<DATA> clone() {
        return new TimeEvictionPolicy<DATA>(this.granularity, this.timestampWrapper);
    }
}

