/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.policy;

import java.util.LinkedList;
import org.apache.flink.streaming.api.windowing.helper.TimestampWrapper;
import org.apache.flink.streaming.api.windowing.policy.ActiveTriggerCallback;
import org.apache.flink.streaming.api.windowing.policy.ActiveTriggerPolicy;
import org.apache.flink.streaming.api.windowing.policy.CloneableTriggerPolicy;

public class TimeTriggerPolicy<DATA>
implements ActiveTriggerPolicy<DATA>,
CloneableTriggerPolicy<DATA> {
    private static final long serialVersionUID = -5122753802440196719L;
    protected long startTime;
    protected long granularity;
    protected TimestampWrapper<DATA> timestampWrapper;
    protected long delay;

    public TimeTriggerPolicy(long granularity, TimestampWrapper<DATA> timestampWrapper) {
        this(granularity, timestampWrapper, 0L);
    }

    public TimeTriggerPolicy(long granularity, TimestampWrapper<DATA> timestampWrapper, long delay) {
        this.startTime = timestampWrapper.getStartTime() + delay;
        this.timestampWrapper = timestampWrapper;
        this.granularity = granularity;
        this.delay = delay;
    }

    @Override
    public synchronized Object[] preNotifyTrigger(DATA datapoint) {
        LinkedList<Long> fakeElements = new LinkedList<Long>();
        while (this.timestampWrapper.getTimestamp(datapoint) >= this.startTime + this.granularity) {
            this.startTime += this.granularity;
            fakeElements.add(this.startTime - 1L);
        }
        return fakeElements.toArray();
    }

    @Override
    public Runnable createActiveTriggerRunnable(ActiveTriggerCallback callback) {
        if (this.timestampWrapper.isDefaultTimestamp()) {
            return new TimeCheck(callback);
        }
        return null;
    }

    private synchronized void activeFakeElementEmission(ActiveTriggerCallback callback) {
        if (System.currentTimeMillis() >= this.startTime + this.granularity) {
            this.startTime += this.granularity;
            callback.sendFakeElement(this.startTime - 1L);
        }
    }

    @Override
    public synchronized boolean notifyTrigger(DATA datapoint) {
        long recordTime = this.timestampWrapper.getTimestamp(datapoint);
        if (recordTime >= this.startTime + this.granularity) {
            if (this.granularity != 0L) {
                this.startTime = recordTime - (recordTime - this.startTime) % this.granularity;
            }
            return true;
        }
        return false;
    }

    @Override
    public TimeTriggerPolicy<DATA> clone() {
        return new TimeTriggerPolicy<DATA>(this.granularity, this.timestampWrapper, this.delay);
    }

    private class TimeCheck
    implements Runnable {
        ActiveTriggerCallback callback;

        public TimeCheck(ActiveTriggerCallback callback) {
            this.callback = callback;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(TimeTriggerPolicy.this.granularity);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                TimeTriggerPolicy.this.activeFakeElementEmission(this.callback);
            }
        }
    }
}

