/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.io;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.event.task.AbstractEvent;
import org.apache.flink.runtime.event.task.AbstractTaskEvent;
import org.apache.flink.runtime.io.network.api.AbstractRecordReader;
import org.apache.flink.runtime.io.network.api.MutableRecordReader;
import org.apache.flink.runtime.io.network.gates.InputChannelResult;
import org.apache.flink.runtime.io.network.gates.InputGate;
import org.apache.flink.runtime.io.network.gates.RecordAvailabilityListener;

public class CoRecordReader<T1 extends IOReadableWritable, T2 extends IOReadableWritable>
extends AbstractRecordReader
implements RecordAvailabilityListener {
    private Set<InputGate<T1>> inputGates1;
    private Set<InputGate<T2>> inputGates2;
    private final Set<InputGate> remainingInputGates;
    private final InputGate[] allInputGates;
    private final ArrayDeque<InputGate> availableInputGates = new ArrayDeque();
    private InputGate nextInputGateToReadFrom;

    public boolean isInputClosed() {
        return this.remainingInputGates.isEmpty();
    }

    public CoRecordReader(ArrayList<MutableRecordReader<T1>> inputList1, ArrayList<MutableRecordReader<T2>> inputList2) {
        InputGate inputGate;
        if (inputList1 == null || inputList2 == null) {
            throw new IllegalArgumentException("Provided argument recordReaders is null");
        }
        this.inputGates1 = new HashSet<InputGate<T1>>();
        this.inputGates2 = new HashSet<InputGate<T2>>();
        this.remainingInputGates = new HashSet<InputGate>((int)((float)(inputList1.size() + inputList2.size()) * 1.6f));
        this.allInputGates = new InputGate[inputList1.size() + inputList2.size()];
        int inputNumber = 0;
        for (MutableRecordReader<T1> mutableRecordReader : inputList1) {
            inputGate = mutableRecordReader.getInputGate();
            inputGate.registerRecordAvailabilityListener((RecordAvailabilityListener)this);
            this.inputGates1.add(inputGate);
            this.remainingInputGates.add(inputGate);
            this.allInputGates[inputNumber] = inputGate;
            ++inputNumber;
        }
        for (MutableRecordReader mutableRecordReader : inputList2) {
            inputGate = mutableRecordReader.getInputGate();
            inputGate.registerRecordAvailabilityListener((RecordAvailabilityListener)this);
            this.inputGates2.add(inputGate);
            this.remainingInputGates.add(inputGate);
            this.allInputGates[inputNumber] = inputGate;
            ++inputNumber;
        }
    }

    public void publishEvent(AbstractTaskEvent event) throws IOException, InterruptedException {
        for (InputGate<T1> inputGate : this.inputGates1) {
            inputGate.publishEvent((AbstractEvent)event);
        }
        for (InputGate inputGate : this.inputGates2) {
            inputGate.publishEvent((AbstractEvent)event);
        }
    }

    public void publishEvent(AbstractTaskEvent event, int inputNumber) throws IOException, InterruptedException {
        this.allInputGates[inputNumber].publishEvent((AbstractEvent)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportRecordAvailability(InputGate inputGate) {
        ArrayDeque<InputGate> arrayDeque = this.availableInputGates;
        synchronized (arrayDeque) {
            this.availableInputGates.add(inputGate);
            this.availableInputGates.notifyAll();
        }
    }

    protected int getNextRecord(T1 target1, T2 target2) throws IOException, InterruptedException {
        while (true) {
            int out;
            InputChannelResult result;
            if (this.nextInputGateToReadFrom == null) {
                if (this.remainingInputGates.isEmpty()) {
                    return 0;
                }
                this.nextInputGateToReadFrom = this.getNextAvailableInputGate();
            }
            if (this.inputGates1.contains(this.nextInputGateToReadFrom)) {
                result = this.nextInputGateToReadFrom.readRecord(target1);
                out = 1;
            } else {
                result = this.nextInputGateToReadFrom.readRecord(target2);
                out = 2;
            }
            switch (result) {
                case INTERMEDIATE_RECORD_FROM_BUFFER: {
                    return out;
                }
                case LAST_RECORD_FROM_BUFFER: {
                    this.nextInputGateToReadFrom = null;
                    return out;
                }
                case END_OF_SUPERSTEP: {
                    this.nextInputGateToReadFrom = null;
                    if (!this.incrementEndOfSuperstepEventAndCheck()) break;
                    return 0;
                }
                case TASK_EVENT: {
                    this.handleEvent(this.nextInputGateToReadFrom.getCurrentEvent());
                    this.nextInputGateToReadFrom = null;
                    break;
                }
                case END_OF_STREAM: {
                    this.remainingInputGates.remove(this.nextInputGateToReadFrom);
                    this.nextInputGateToReadFrom = null;
                    break;
                }
                case NONE: {
                    this.nextInputGateToReadFrom = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputGate getNextAvailableInputGate() throws InterruptedException {
        ArrayDeque<InputGate> arrayDeque = this.availableInputGates;
        synchronized (arrayDeque) {
            while (this.availableInputGates.isEmpty()) {
                this.availableInputGates.wait();
            }
            return this.availableInputGates.pop();
        }
    }
}

