/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.io;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.Buffer;
import org.apache.flink.runtime.io.network.api.ChannelSelector;
import org.apache.flink.runtime.io.network.api.RecordWriter;
import org.apache.flink.runtime.io.network.api.RoundRobinChannelSelector;
import org.apache.flink.runtime.io.network.bufferprovider.BufferProvider;
import org.apache.flink.runtime.io.network.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;

public class StreamRecordWriter<T extends IOReadableWritable>
extends RecordWriter<T> {
    private final BufferProvider bufferPool;
    private final ChannelSelector<T> channelSelector;
    private int numChannels;
    private long timeout;
    private OutputFlusher outputFlusher;
    private RecordSerializer<T>[] serializers;
    private ArrayList<TargetChannel> targetChannels;

    public StreamRecordWriter(AbstractInvokable invokable) {
        this(invokable, (ChannelSelector<T>)new RoundRobinChannelSelector(), 1000L);
    }

    public StreamRecordWriter(AbstractInvokable invokable, ChannelSelector<T> channelSelector) {
        this(invokable, channelSelector, 1000L);
    }

    public StreamRecordWriter(AbstractInvokable invokable, ChannelSelector<T> channelSelector, long timeout) {
        super(invokable);
        this.timeout = timeout;
        this.bufferPool = invokable.getEnvironment().getOutputBufferProvider();
        this.channelSelector = channelSelector;
    }

    public void initializeSerializers() {
        this.numChannels = this.outputGate.getNumChannels();
        this.serializers = new RecordSerializer[this.numChannels];
        this.targetChannels = new ArrayList(this.numChannels);
        for (int i = 0; i < this.numChannels; ++i) {
            this.serializers[i] = new SpanningRecordSerializer();
            this.targetChannels.add(new TargetChannel(i));
        }
        this.outputFlusher = new OutputFlusher();
        this.outputFlusher.start();
    }

    public void emit(T record) throws IOException, InterruptedException {
        for (int targetChannel : this.channelSelector.selectChannels(record, this.numChannels)) {
            this.targetChannels.get(targetChannel).emit(record);
        }
    }

    public void flush() throws IOException, InterruptedException {
        for (int targetChannel = 0; targetChannel < this.numChannels; ++targetChannel) {
            this.targetChannels.get(targetChannel).flush();
        }
    }

    public void close() {
        try {
            if (this.outputFlusher != null) {
                this.outputFlusher.terminate();
                this.outputFlusher.join();
            }
            this.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class OutputFlusher
    extends Thread {
        private boolean running = true;

        private OutputFlusher() {
        }

        public void terminate() {
            this.running = false;
        }

        @Override
        public void run() {
            while (this.running && !StreamRecordWriter.this.outputGate.isClosed()) {
                try {
                    StreamRecordWriter.this.flush();
                    Thread.sleep(StreamRecordWriter.this.timeout);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class TargetChannel {
        private int targetChannel;
        private RecordSerializer<T> serializer;

        public TargetChannel(int targetChannel) {
            this.targetChannel = targetChannel;
            this.serializer = StreamRecordWriter.this.serializers[targetChannel];
        }

        public synchronized void emit(T record) throws IOException, InterruptedException {
            RecordSerializer.SerializationResult result = this.serializer.addRecord(record);
            while (result.isFullBuffer()) {
                Buffer buffer = this.serializer.getCurrentBuffer();
                if (buffer != null) {
                    StreamRecordWriter.this.sendBuffer(buffer, this.targetChannel);
                }
                buffer = StreamRecordWriter.this.bufferPool.requestBufferBlocking(StreamRecordWriter.this.bufferPool.getBufferSize());
                result = this.serializer.setNextBuffer(buffer);
            }
        }

        public synchronized void flush() throws IOException, InterruptedException {
            Buffer buffer = this.serializer.getCurrentBuffer();
            if (buffer != null) {
                StreamRecordWriter.this.sendBuffer(buffer, this.targetChannel);
            }
            this.serializer.clear();
        }
    }
}

