/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.state;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class CircularFifoList<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Queue<T> queue = new LinkedList<T>();
    private Queue<Long> slideSizes = new LinkedList<Long>();
    private long counter = 0L;
    private Iterable<T> iterable = new ListIterable();

    public void add(T element) {
        this.queue.add(element);
        ++this.counter;
    }

    public void newSlide() {
        this.slideSizes.add(this.counter);
        this.counter = 0L;
    }

    public void shiftWindow() {
        this.shiftWindow(1);
    }

    public void shiftWindow(int numberOfSlides) {
        if (numberOfSlides <= this.slideSizes.size()) {
            for (int i = 0; i < numberOfSlides; ++i) {
                Long firstSlideSize = this.slideSizes.remove();
                int j = 0;
                while ((long)j < firstSlideSize) {
                    this.queue.remove();
                    ++j;
                }
            }
        } else {
            this.slideSizes.clear();
            this.queue.clear();
            this.counter = 0L;
        }
    }

    public List<T> getElements() {
        return (List)((Object)this.queue);
    }

    public Iterator<T> getIterator() {
        return this.queue.iterator();
    }

    public Iterable<T> getIterable() {
        return this.iterable;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public String toString() {
        return this.queue.toString();
    }

    private class ListIterable
    implements Iterable<T>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ListIterable() {
        }

        @Override
        public Iterator<T> iterator() {
            return CircularFifoList.this.getIterator();
        }
    }
}

