/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.state;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;

public class NullableCircularBuffer
extends AbstractCollection
implements Buffer,
BoundedCollection,
Serializable {
    private static final long serialVersionUID = 5603722811189451017L;
    private transient Object[] elements;
    private transient int start = 0;
    private transient int end = 0;
    private transient boolean full = false;
    private final int maxElements;

    public NullableCircularBuffer() {
        this(32);
    }

    public NullableCircularBuffer(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.elements = new Object[size];
        this.maxElements = this.elements.length;
    }

    public NullableCircularBuffer(Collection coll) {
        this(coll.size());
        this.addAll(coll);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            out.writeObject(it.next());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.elements = new Object[this.maxElements];
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.elements[i] = in.readObject();
        }
        this.start = 0;
        this.full = size == this.maxElements;
        this.end = this.full ? 0 : size;
    }

    @Override
    public int size() {
        int size = 0;
        size = this.end < this.start ? this.maxElements - this.start + this.end : (this.end == this.start ? (this.full ? this.maxElements : 0) : this.end - this.start);
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.size() == this.maxElements;
    }

    public int maxSize() {
        return this.maxElements;
    }

    @Override
    public void clear() {
        this.full = false;
        this.start = 0;
        this.end = 0;
        Arrays.fill(this.elements, null);
    }

    @Override
    public boolean add(Object element) {
        if (this.isFull()) {
            this.remove();
        }
        this.elements[this.end++] = element;
        if (this.end >= this.maxElements) {
            this.end = 0;
        }
        if (this.end == this.start) {
            this.full = true;
        }
        return true;
    }

    public Object get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        return this.elements[this.start];
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object element = this.elements[this.start];
        this.elements[this.start++] = null;
        if (this.start >= this.maxElements) {
            this.start = 0;
        }
        this.full = false;
        return element;
    }

    private int increment(int index) {
        if (++index >= this.maxElements) {
            index = 0;
        }
        return index;
    }

    private int decrement(int index) {
        if (--index < 0) {
            index = this.maxElements - 1;
        }
        return index;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private int index;
            private int lastReturnedIndex;
            private boolean isFirst;
            {
                this.index = NullableCircularBuffer.this.start;
                this.lastReturnedIndex = -1;
                this.isFirst = NullableCircularBuffer.this.full;
            }

            @Override
            public boolean hasNext() {
                return this.isFirst || this.index != NullableCircularBuffer.this.end;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.isFirst = false;
                this.lastReturnedIndex = this.index;
                this.index = NullableCircularBuffer.this.increment(this.index);
                return NullableCircularBuffer.this.elements[this.lastReturnedIndex];
            }

            @Override
            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == NullableCircularBuffer.this.start) {
                    NullableCircularBuffer.this.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int pos = this.lastReturnedIndex + 1;
                if (NullableCircularBuffer.this.start < this.lastReturnedIndex && pos < NullableCircularBuffer.this.end) {
                    System.arraycopy(NullableCircularBuffer.this.elements, pos, NullableCircularBuffer.this.elements, this.lastReturnedIndex, NullableCircularBuffer.this.end - pos);
                } else {
                    while (pos != NullableCircularBuffer.this.end) {
                        if (pos >= NullableCircularBuffer.this.maxElements) {
                            ((NullableCircularBuffer)NullableCircularBuffer.this).elements[pos - 1] = NullableCircularBuffer.this.elements[0];
                            pos = 0;
                            continue;
                        }
                        ((NullableCircularBuffer)NullableCircularBuffer.this).elements[((NullableCircularBuffer)NullableCircularBuffer.this).decrement((int)pos)] = NullableCircularBuffer.this.elements[pos];
                        pos = NullableCircularBuffer.this.increment(pos);
                    }
                }
                this.lastReturnedIndex = -1;
                NullableCircularBuffer.this.end = NullableCircularBuffer.this.decrement(NullableCircularBuffer.this.end);
                ((NullableCircularBuffer)NullableCircularBuffer.this).elements[((NullableCircularBuffer)NullableCircularBuffer.this).end] = null;
                NullableCircularBuffer.this.full = false;
                this.index = NullableCircularBuffer.this.decrement(this.index);
            }
        };
    }
}

