/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.state.checkpoint;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.state.MapState;
import org.apache.flink.streaming.state.OperatorState;
import org.apache.flink.streaming.state.checkpoint.StateCheckpoint;

public class MapCheckpoint<K, V>
extends StateCheckpoint<Map<K, V>> {
    private static final long serialVersionUID = 1L;
    protected Set<K> removedItems;
    protected Map<K, V> updatedItems;
    protected boolean clear;

    public MapCheckpoint(OperatorState<Map<K, V>> operatorState) {
        if (operatorState instanceof MapState) {
            MapState mapState = (MapState)operatorState;
            this.removedItems = mapState.getRemovedItems();
            this.clear = mapState.isCleared();
            this.updatedItems = new HashMap();
            for (Object key : mapState.getUpdatedItems()) {
                this.updatedItems.put(key, mapState.get(key));
            }
        } else {
            throw new RuntimeException("MapCheckpoint can only be used with MapState");
        }
        this.checkpointedState = this.updatedItems;
    }

    @Override
    public StateCheckpoint<Map<K, V>> update(StateCheckpoint<Map<K, V>> nextCheckpoint) {
        MapCheckpoint mapCheckpoint = (MapCheckpoint)nextCheckpoint;
        if (this.checkpointedState == null) {
            this.checkpointedState = mapCheckpoint.updatedItems;
        } else {
            if (mapCheckpoint.clear) {
                ((Map)this.checkpointedState).clear();
            }
            for (K key : mapCheckpoint.removedItems) {
                ((Map)this.checkpointedState).remove(key);
            }
            ((Map)this.checkpointedState).putAll(mapCheckpoint.updatedItems);
        }
        return this;
    }
}

