/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;

public abstract class PlanExecutor {
    private static final String LOCAL_EXECUTOR_CLASS = "org.apache.flink.client.LocalExecutor";
    private static final String REMOTE_EXECUTOR_CLASS = "org.apache.flink.client.RemoteExecutor";

    public abstract JobExecutionResult executePlan(Plan var1) throws Exception;

    public abstract String getOptimizerPlanAsJSON(Plan var1) throws Exception;

    public static PlanExecutor createLocalExecutor() {
        Class<? extends PlanExecutor> leClass = PlanExecutor.loadExecutorClass(LOCAL_EXECUTOR_CLASS);
        try {
            return leClass.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred while loading the local executor (org.apache.flink.client.LocalExecutor).", t);
        }
    }

    public static PlanExecutor createRemoteExecutor(String hostname, int port, String ... jarFiles) {
        if (hostname == null) {
            throw new IllegalArgumentException("The hostname must not be null.");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("The port value is out of range.");
        }
        Class<? extends PlanExecutor> reClass = PlanExecutor.loadExecutorClass(REMOTE_EXECUTOR_CLASS);
        List files = jarFiles == null || jarFiles.length == 0 ? Collections.emptyList() : Arrays.asList(jarFiles);
        try {
            return reClass.getConstructor(String.class, Integer.TYPE, List.class).newInstance(hostname, port, files);
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred while loading the remote executor (org.apache.flink.client.RemoteExecutor).", t);
        }
    }

    private static Class<? extends PlanExecutor> loadExecutorClass(String className) {
        try {
            Class<?> leClass = Class.forName(className);
            return leClass.asSubclass(PlanExecutor.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not load the executor class (" + className + "). Do you have the 'flink-clients' project in your dependencies?");
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred while loading the executor (" + className + ").", t);
        }
    }
}

