/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.accumulators.Accumulator;

public class AccumulatorHelper {
    public static void mergeInto(Map<String, Accumulator<?, ?>> target, Map<String, Accumulator<?, ?>> toMerge) {
        for (Map.Entry<String, Accumulator<?, ?>> otherEntry : toMerge.entrySet()) {
            Accumulator<?, ?> ownAccumulator = target.get(otherEntry.getKey());
            if (ownAccumulator == null) {
                target.put(otherEntry.getKey(), otherEntry.getValue());
                continue;
            }
            AccumulatorHelper.compareAccumulatorTypes(otherEntry.getKey(), ownAccumulator.getClass(), otherEntry.getValue().getClass());
            AccumulatorHelper.mergeSingle(ownAccumulator, otherEntry.getValue());
        }
    }

    private static final <V, R> void mergeSingle(Accumulator<?, ?> target, Accumulator<?, ?> toMerge) {
        Accumulator<?, ?> typedTarget = target;
        Accumulator<?, ?> typedToMerge = toMerge;
        typedTarget.merge(typedToMerge);
    }

    public static void compareAccumulatorTypes(Object name, Class<? extends Accumulator> first, Class<? extends Accumulator> second) throws UnsupportedOperationException {
        if (first != second) {
            throw new UnsupportedOperationException("The accumulator object '" + name + "' was created with two different types: " + first + " and " + second);
        }
    }

    public static Map<String, Object> toResultMap(Map<String, Accumulator<?, ?>> accumulators) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Accumulator<?, ?>> entry : accumulators.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue().getLocalValue());
        }
        return resultMap;
    }

    public static String getAccumulatorsFormated(Map<?, Accumulator<?, ?>> newAccumulators) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<?, Accumulator<?, ?>> entry : newAccumulators.entrySet()) {
            builder.append("- " + entry.getKey() + " (" + entry.getValue().getClass().getName() + ")" + ": " + entry.getValue().toString() + "\n");
        }
        return builder.toString();
    }

    public static String getResultsFormated(Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            builder.append("- " + entry.getKey() + " (" + entry.getValue().getClass().getName() + ")" + ": " + entry.getValue().toString() + "\n");
        }
        return builder.toString();
    }

    public static void resetAndClearAccumulators(Map<String, Accumulator<?, ?>> accumulators) {
        for (Map.Entry<String, Accumulator<?, ?>> entry : accumulators.entrySet()) {
            entry.getValue().resetLocal();
        }
        accumulators.clear();
    }
}

