/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import java.io.IOException;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class DoubleCounter
implements SimpleAccumulator<Double> {
    private static final long serialVersionUID = 1L;
    private double localValue = 0.0;

    @Override
    public void add(Double value) {
        this.localValue += value.doubleValue();
    }

    @Override
    public Double getLocalValue() {
        return this.localValue;
    }

    @Override
    public void merge(Accumulator<Double, Double> other) {
        this.localValue += ((DoubleCounter)other).getLocalValue().doubleValue();
    }

    @Override
    public void resetLocal() {
        this.localValue = 0.0;
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeDouble(this.localValue);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.localValue = in.readDouble();
    }

    public String toString() {
        return "DoubleCounter object. Local value: " + this.localValue;
    }
}

