/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import java.io.IOException;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class LongCounter
implements SimpleAccumulator<Long> {
    private static final long serialVersionUID = 1L;
    private long localValue = 0L;

    @Override
    public void add(Long value) {
        this.localValue += value.longValue();
    }

    @Override
    public Long getLocalValue() {
        return this.localValue;
    }

    @Override
    public void merge(Accumulator<Long, Long> other) {
        this.localValue += ((LongCounter)other).getLocalValue().longValue();
    }

    @Override
    public void resetLocal() {
        this.localValue = 0L;
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeLong(this.localValue);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.localValue = in.readLong();
    }

    public String toString() {
        return "LongCounter object. Local value: " + this.localValue;
    }
}

