/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.cache;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.FutureTask;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;

public class DistributedCache {
    static final String CACHE_FILE_NUM = "DISTRIBUTED_CACHE_FILE_NUM";
    static final String CACHE_FILE_NAME = "DISTRIBUTED_CACHE_FILE_NAME_";
    static final String CACHE_FILE_PATH = "DISTRIBUTED_CACHE_FILE_PATH_";
    static final String CACHE_FILE_EXE = "DISTRIBUTED_CACHE_FILE_EXE_";
    public static final String TMP_PREFIX = "tmp_";
    private Map<String, FutureTask<Path>> cacheCopyTasks = new HashMap<String, FutureTask<Path>>();

    public static void writeFileInfoToConfig(String name, DistributedCacheEntry e, Configuration conf) {
        int num = conf.getInteger(CACHE_FILE_NUM, 0) + 1;
        conf.setInteger(CACHE_FILE_NUM, num);
        conf.setString(CACHE_FILE_NAME + num, name);
        conf.setString(CACHE_FILE_PATH + num, e.filePath);
        conf.setBoolean(CACHE_FILE_EXE + num, e.isExecutable != false || new File(e.filePath).canExecute());
    }

    public static Set<Map.Entry<String, DistributedCacheEntry>> readFileInfoFromConfig(Configuration conf) {
        HashMap<String, DistributedCacheEntry> cacheFiles = new HashMap<String, DistributedCacheEntry>();
        int num = conf.getInteger(CACHE_FILE_NUM, 0);
        for (int i = 1; i <= num; ++i) {
            String name = conf.getString(CACHE_FILE_NAME + i, "");
            String filePath = conf.getString(CACHE_FILE_PATH + i, "");
            Boolean isExecutable = conf.getBoolean(CACHE_FILE_EXE + i, false);
            cacheFiles.put(name, new DistributedCacheEntry(filePath, isExecutable));
        }
        return cacheFiles.entrySet();
    }

    public void setCopyTasks(Map<String, FutureTask<Path>> cpTasks) {
        this.cacheCopyTasks = cpTasks;
    }

    public File getFile(String name) {
        Path tmp = null;
        try {
            tmp = this.cacheCopyTasks.get(name).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting file from distributed cache", e);
        }
        return new File(tmp.toString());
    }

    public static class DistributedCacheEntry {
        public String filePath;
        public Boolean isExecutable;

        public DistributedCacheEntry(String filePath, Boolean isExecutable) {
            this.filePath = filePath;
            this.isExecutable = isExecutable;
        }
    }
}

