/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.distributions;

import java.io.IOException;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Key;
import org.apache.flink.util.InstantiationUtil;

public class SimpleDistribution
implements DataDistribution {
    private static final long serialVersionUID = 1L;
    protected Key<?>[][] boundaries;
    protected int dim;

    public SimpleDistribution() {
        this.boundaries = new Key[0][];
    }

    public SimpleDistribution(Key<?>[] bucketBoundaries) {
        if (bucketBoundaries == null) {
            throw new IllegalArgumentException("Bucket boundaries must not be null.");
        }
        if (bucketBoundaries.length == 0) {
            throw new IllegalArgumentException("Bucket boundaries must not be empty.");
        }
        this.dim = 1;
        Class<?> clazz = bucketBoundaries[0].getClass();
        this.boundaries = new Key[bucketBoundaries.length][];
        for (int i = 0; i < bucketBoundaries.length; ++i) {
            if (bucketBoundaries[i].getClass() != clazz) {
                throw new IllegalArgumentException("The bucket boundaries are of different class types.");
            }
            this.boundaries[i] = new Key[]{bucketBoundaries[i]};
        }
    }

    public SimpleDistribution(Key<?>[][] bucketBoundaries) {
        int i;
        if (bucketBoundaries == null) {
            throw new IllegalArgumentException("Bucket boundaries must not be null.");
        }
        if (bucketBoundaries.length == 0) {
            throw new IllegalArgumentException("Bucket boundaries must not be empty.");
        }
        this.dim = bucketBoundaries[0].length;
        Class[] types = new Class[this.dim];
        for (i = 0; i < this.dim; ++i) {
            types[i] = bucketBoundaries[0][i].getClass();
        }
        for (i = 1; i < bucketBoundaries.length; ++i) {
            if (bucketBoundaries[i].length != this.dim) {
                throw new IllegalArgumentException("All bucket boundaries must have the same dimensionality.");
            }
            for (int d = 0; d < this.dim; ++d) {
                if (types[d] == bucketBoundaries[i][d].getClass()) continue;
                throw new IllegalArgumentException("The bucket boundaries are of different class types.");
            }
        }
        this.boundaries = bucketBoundaries;
    }

    @Override
    public int getNumberOfFields() {
        return this.dim;
    }

    @Override
    public Key<?>[] getBucketBoundary(int bucketNum, int totalNumBuckets) {
        if (bucketNum < 0) {
            throw new IllegalArgumentException("Requested bucket must be greater than or equal to 0.");
        }
        if (bucketNum >= totalNumBuckets - 1) {
            throw new IllegalArgumentException("Request bucket must be smaller than the total number of buckets minus 1.");
        }
        if (totalNumBuckets < 1) {
            throw new IllegalArgumentException("Total number of bucket must be larger than 0.");
        }
        int maxNumBuckets = this.boundaries.length + 1;
        if (maxNumBuckets % totalNumBuckets == 0) {
            int n = maxNumBuckets / totalNumBuckets;
            int bucketId = bucketNum * n + (n - 1);
            return this.boundaries[bucketId];
        }
        throw new IllegalArgumentException("Interpolation of bucket boundaries currently not supported. Please use an even divider of the maximum possible buckets (here: " + maxNumBuckets + ") as totalBuckets.");
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        int i;
        out.writeInt(this.dim);
        out.writeInt(this.boundaries.length);
        for (i = 0; i < this.dim; ++i) {
            out.writeUTF(this.boundaries[0][i].getClass().getName());
        }
        for (i = 0; i < this.boundaries.length; ++i) {
            for (int d = 0; d < this.dim; ++d) {
                this.boundaries[i][d].write(out);
            }
        }
    }

    @Override
    public void read(DataInputView in) throws IOException {
        int i;
        this.dim = in.readInt();
        int len = in.readInt();
        this.boundaries = new Key[len][];
        Class[] types = new Class[this.dim];
        for (i = 0; i < this.dim; ++i) {
            String className = in.readUTF();
            try {
                types[i] = Class.forName(className, true, this.getClass().getClassLoader()).asSubclass(Key.class);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Could not load type class '" + className + "'.");
            }
            catch (Throwable t) {
                throw new IOException("Error loading type class '" + className + "'.", t);
            }
        }
        for (i = 0; i < len; ++i) {
            Key[] bucket = new Key[this.dim];
            for (int d = 0; d < this.dim; ++d) {
                Key val = InstantiationUtil.instantiate(types[d], Key.class);
                val.read(in);
                bucket[d] = val;
            }
            this.boundaries[i] = bucket;
        }
    }
}

