/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.distributions;

import java.io.IOException;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.IntValue;

public class UniformIntegerDistribution
implements DataDistribution {
    private static final long serialVersionUID = 1L;
    private int min;
    private int max;

    public UniformIntegerDistribution() {
    }

    public UniformIntegerDistribution(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public IntValue[] getBucketBoundary(int bucketNum, int totalNumBuckets) {
        long diff = (long)this.max - (long)this.min + 1L;
        double bucketSize = (double)diff / (double)totalNumBuckets;
        return new IntValue[]{new IntValue(this.min + (int)((double)(bucketNum + 1) * bucketSize))};
    }

    @Override
    public int getNumberOfFields() {
        return 1;
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.min);
        out.writeInt(this.max);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.min = in.readInt();
        this.max = in.readInt();
    }
}

