/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.FutureTask;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.api.common.accumulators.DoubleCounter;
import org.apache.flink.api.common.accumulators.Histogram;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.core.fs.Path;

public abstract class AbstractRuntimeUDFContext
implements RuntimeContext {
    private final String name;
    private final int numParallelSubtasks;
    private final int subtaskIndex;
    private final ClassLoader userCodeClassLoader;
    private final HashMap<String, Accumulator<?, ?>> accumulators = new HashMap();
    private final DistributedCache distributedCache = new DistributedCache();

    public AbstractRuntimeUDFContext(String name, int numParallelSubtasks, int subtaskIndex, ClassLoader userCodeClassLoader) {
        this.name = name;
        this.numParallelSubtasks = numParallelSubtasks;
        this.subtaskIndex = subtaskIndex;
        this.userCodeClassLoader = userCodeClassLoader;
    }

    public AbstractRuntimeUDFContext(String name, int numParallelSubtasks, int subtaskIndex, ClassLoader userCodeClassLoader, Map<String, FutureTask<Path>> cpTasks) {
        this(name, numParallelSubtasks, subtaskIndex, userCodeClassLoader);
        this.distributedCache.setCopyTasks(cpTasks);
    }

    @Override
    public String getTaskName() {
        return this.name;
    }

    @Override
    public int getNumberOfParallelSubtasks() {
        return this.numParallelSubtasks;
    }

    @Override
    public int getIndexOfThisSubtask() {
        return this.subtaskIndex;
    }

    @Override
    public IntCounter getIntCounter(String name) {
        return (IntCounter)this.getAccumulator(name, IntCounter.class);
    }

    @Override
    public LongCounter getLongCounter(String name) {
        return (LongCounter)this.getAccumulator(name, LongCounter.class);
    }

    @Override
    public Histogram getHistogram(String name) {
        return (Histogram)this.getAccumulator(name, Histogram.class);
    }

    @Override
    public DoubleCounter getDoubleCounter(String name) {
        return (DoubleCounter)this.getAccumulator(name, DoubleCounter.class);
    }

    @Override
    public <V, A> void addAccumulator(String name, Accumulator<V, A> accumulator) {
        if (this.accumulators.containsKey(name)) {
            throw new UnsupportedOperationException("The counter '" + name + "' already exists and cannot be added.");
        }
        this.accumulators.put(name, accumulator);
    }

    @Override
    public <V, A> Accumulator<V, A> getAccumulator(String name) {
        return this.accumulators.get(name);
    }

    @Override
    public HashMap<String, Accumulator<?, ?>> getAllAccumulators() {
        return this.accumulators;
    }

    @Override
    public ClassLoader getUserCodeClassLoader() {
        return this.userCodeClassLoader;
    }

    @Override
    public DistributedCache getDistributedCache() {
        return this.distributedCache;
    }

    private <V, A> Accumulator<V, A> getAccumulator(String name, Class<? extends Accumulator<V, A>> accumulatorClass) {
        Accumulator<Object, Object> accumulator = this.accumulators.get(name);
        if (accumulator != null) {
            AccumulatorHelper.compareAccumulatorTypes(name, accumulator.getClass(), accumulatorClass);
        } else {
            try {
                accumulator = accumulatorClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            this.accumulators.put(name, accumulator);
        }
        return accumulator;
    }
}

