/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.api.common.io.BlockInfo;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.OutputViewDataOutputStreamWrapper;

public abstract class BinaryOutputFormat<T>
extends FileOutputFormat<T> {
    private static final long serialVersionUID = 1L;
    public static final String BLOCK_SIZE_PARAMETER_KEY = "output.block_size";
    public static final long NATIVE_BLOCK_SIZE = Long.MIN_VALUE;
    private long blockSize = Long.MIN_VALUE;
    private DataOutputStream dataOutputStream;
    private BlockBasedOutput blockBasedInput;

    @Override
    public void close() throws IOException {
        this.dataOutputStream.close();
        super.close();
    }

    protected void complementBlockInfo(BlockInfo blockInfo) throws IOException {
    }

    @Override
    public void configure(Configuration parameters) {
        super.configure(parameters);
        this.blockSize = parameters.getLong(BLOCK_SIZE_PARAMETER_KEY, Long.MIN_VALUE);
        if (this.blockSize < 1L && this.blockSize != Long.MIN_VALUE) {
            throw new IllegalArgumentException("The block size parameter must be set and larger than 0.");
        }
        if (this.blockSize > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Currently only block size up to Integer.MAX_VALUE are supported");
        }
    }

    protected BlockInfo createBlockInfo() {
        return new BlockInfo();
    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        long blockSize = this.blockSize == Long.MIN_VALUE ? this.outputFilePath.getFileSystem().getDefaultBlockSize() : this.blockSize;
        this.blockBasedInput = new BlockBasedOutput(this.stream, (int)blockSize);
        this.dataOutputStream = new DataOutputStream(this.blockBasedInput);
    }

    protected abstract void serialize(T var1, DataOutputView var2) throws IOException;

    @Override
    public void writeRecord(T record) throws IOException {
        this.blockBasedInput.startRecord();
        this.serialize(record, new OutputViewDataOutputStreamWrapper(this.dataOutputStream));
    }

    protected class BlockBasedOutput
    extends FilterOutputStream {
        private static final int NO_RECORD = -1;
        private final int maxPayloadSize;
        private int blockPos;
        private int blockCount;
        private int totalCount;
        private long firstRecordStartPos;
        private BlockInfo blockInfo;
        private DataOutputStream headerStream;

        public BlockBasedOutput(OutputStream out, int blockSize) {
            super(out);
            this.firstRecordStartPos = -1L;
            this.blockInfo = BinaryOutputFormat.this.createBlockInfo();
            this.headerStream = new DataOutputStream(out);
            this.maxPayloadSize = blockSize - this.blockInfo.getInfoSize();
        }

        @Override
        public void close() throws IOException {
            if (this.blockPos > 0) {
                this.writeInfo();
            }
            super.flush();
            super.close();
        }

        public void startRecord() {
            if (this.firstRecordStartPos == -1L) {
                this.firstRecordStartPos = this.blockPos;
            }
            ++this.blockCount;
            ++this.totalCount;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int remainingLength = len;
            int offset = off;
            while (remainingLength > 0) {
                int blockLen = Math.min(remainingLength, this.maxPayloadSize - this.blockPos);
                this.out.write(b, offset, blockLen);
                this.blockPos += blockLen;
                if (this.blockPos >= this.maxPayloadSize) {
                    this.writeInfo();
                }
                remainingLength -= blockLen;
                offset += blockLen;
            }
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            if (++this.blockPos >= this.maxPayloadSize) {
                this.writeInfo();
            }
        }

        private void writeInfo() throws IOException {
            this.blockInfo.setRecordCount(this.blockCount);
            this.blockInfo.setAccumulatedRecordCount(this.totalCount);
            this.blockInfo.setFirstRecordStart(this.firstRecordStartPos == -1L ? 0L : this.firstRecordStartPos);
            BinaryOutputFormat.this.complementBlockInfo(this.blockInfo);
            this.blockInfo.write(new OutputViewDataOutputStreamWrapper(this.headerStream));
            this.blockPos = 0;
            this.blockCount = 0;
            this.firstRecordStartPos = -1L;
        }
    }
}

