/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.common.operators.base.FileDataSourceBase;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.com.google.common.base.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelimitedInputFormat<OT>
extends FileInputFormat<OT> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DelimitedInputFormat.class);
    private static final int DEFAULT_READ_BUFFER_SIZE = 0x100000;
    private static final int NUM_SAMPLES_UNDEFINED = -1;
    private static int DEFAULT_MAX_NUM_SAMPLES;
    private static int DEFAULT_MIN_NUM_SAMPLES;
    private static int MAX_SAMPLE_LEN;
    private transient byte[] readBuffer;
    private transient byte[] wrapBuffer;
    private transient int readPos;
    private transient int limit;
    private transient byte[] currBuffer;
    private transient int currOffset;
    private transient int currLen;
    private transient boolean overLimit;
    private transient boolean end;
    private byte[] delimiter = new byte[]{10};
    private int lineLengthLimit = Integer.MAX_VALUE;
    private int bufferSize = -1;
    private int numLineSamples = -1;
    protected static final String RECORD_DELIMITER = "delimited-format.delimiter";
    private static final String RECORD_DELIMITER_ENCODING = "delimited-format.delimiter-encoding";
    private static final String NUM_STATISTICS_SAMPLES = "delimited-format.numSamples";

    protected static final void loadGloablConfigParams() {
        int maxSamples = GlobalConfiguration.getInteger("compiler.delimited-informat.max-line-samples", 10);
        int minSamples = GlobalConfiguration.getInteger("compiler.delimited-informat.min-line-samples", 2);
        if (maxSamples < 0) {
            LOG.error("Invalid default maximum number of line samples: " + maxSamples + ". Using default value of " + 10);
            maxSamples = 10;
        }
        if (minSamples < 0) {
            LOG.error("Invalid default minimum number of line samples: " + minSamples + ". Using default value of " + 2);
            minSamples = 2;
        }
        DEFAULT_MAX_NUM_SAMPLES = maxSamples;
        if (minSamples > maxSamples) {
            LOG.error("Defaul minimum number of line samples cannot be greater the default maximum number of line samples: min=" + minSamples + ", max=" + maxSamples + ". Defaulting minumum to maximum.");
            DEFAULT_MIN_NUM_SAMPLES = maxSamples;
        } else {
            DEFAULT_MIN_NUM_SAMPLES = minSamples;
        }
        int maxLen = GlobalConfiguration.getInteger("compiler.delimited-informat.max-sample-len", 0x200000);
        if (maxLen <= 0) {
            maxLen = 0x200000;
            LOG.error("Invalid value for the maximum sample record length. Using defailt value of " + maxLen + '.');
        } else if (maxLen < 0x100000) {
            maxLen = 0x100000;
            LOG.warn("Increasing maximum sample record length to size of the read buffer (" + maxLen + ").");
        }
        MAX_SAMPLE_LEN = maxLen;
    }

    public DelimitedInputFormat() {
    }

    protected DelimitedInputFormat(Path filePath) {
        super(filePath);
    }

    public byte[] getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(byte[] delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Delimiter must not be null");
        }
        this.delimiter = delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.setDelimiter(String.valueOf(delimiter));
    }

    public void setDelimiter(String delimiter) {
        this.setDelimiter(delimiter, Charsets.UTF_8);
    }

    public void setDelimiter(String delimiter, String charsetName) throws IllegalCharsetNameException, UnsupportedCharsetException {
        if (charsetName == null) {
            throw new IllegalArgumentException("Charset name must not be null");
        }
        Charset charset = Charset.forName(charsetName);
        this.setDelimiter(delimiter, charset);
    }

    public void setDelimiter(String delimiter, Charset charset) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Delimiter must not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Charset must not be null");
        }
        this.delimiter = delimiter.getBytes(charset);
    }

    public int getLineLengthLimit() {
        return this.lineLengthLimit;
    }

    public void setLineLengthLimit(int lineLengthLimit) {
        if (lineLengthLimit < 1) {
            throw new IllegalArgumentException("Line length limit must be at least 1.");
        }
        this.lineLengthLimit = lineLengthLimit;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be at least 1.");
        }
        this.bufferSize = bufferSize;
    }

    public int getNumLineSamples() {
        return this.numLineSamples;
    }

    public void setNumLineSamples(int numLineSamples) {
        if (numLineSamples < 0) {
            throw new IllegalArgumentException("Number of line samples must not be negative.");
        }
        this.numLineSamples = numLineSamples;
    }

    public abstract OT readRecord(OT var1, byte[] var2, int var3, int var4) throws IOException;

    @Override
    public void configure(Configuration parameters) {
        String samplesString;
        super.configure(parameters);
        String delimString = parameters.getString(RECORD_DELIMITER, null);
        if (delimString != null) {
            String charsetName = parameters.getString(RECORD_DELIMITER_ENCODING, null);
            if (charsetName == null) {
                this.setDelimiter(delimString);
            } else {
                try {
                    this.setDelimiter(delimString, charsetName);
                }
                catch (UnsupportedCharsetException e) {
                    throw new IllegalArgumentException("The charset with the name '" + charsetName + "' is not supported on this TaskManager instance.", e);
                }
            }
        }
        if ((samplesString = parameters.getString(NUM_STATISTICS_SAMPLES, null)) != null) {
            try {
                this.setNumLineSamples(Integer.parseInt(samplesString));
            }
            catch (NumberFormatException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Invalid value for number of samples to take: " + samplesString + ". Skipping sampling.");
                }
                this.setNumLineSamples(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInputFormat.FileBaseStatistics getStatistics(BaseStatistics cachedStats) throws IOException {
        FileInputFormat.FileBaseStatistics cachedFileStats = cachedStats != null && cachedStats instanceof FileInputFormat.FileBaseStatistics ? (FileInputFormat.FileBaseStatistics)cachedStats : null;
        long oldTimeout = this.openTimeout;
        int oldBufferSize = this.bufferSize;
        int oldLineLengthLimit = this.lineLengthLimit;
        try {
            int numSamples;
            Path filePath = this.filePath;
            FileSystem fs = FileSystem.get(filePath.toUri());
            ArrayList<FileStatus> allFiles = new ArrayList<FileStatus>(1);
            FileInputFormat.FileBaseStatistics stats = this.getFileStats(cachedFileStats, filePath, fs, allFiles);
            if (stats == null) {
                FileInputFormat.FileBaseStatistics fileBaseStatistics = null;
                return fileBaseStatistics;
            }
            if (stats.getAverageRecordWidth() != -1.0f || stats.getTotalInputSize() == -1L) {
                FileInputFormat.FileBaseStatistics fileBaseStatistics = stats;
                return fileBaseStatistics;
            }
            if (this.unsplittable) {
                FileInputFormat.FileBaseStatistics fileBaseStatistics = stats;
                return fileBaseStatistics;
            }
            if (this.numLineSamples != -1) {
                numSamples = this.numLineSamples;
            } else {
                int calcSamples = (int)(stats.getTotalInputSize() / 1024L);
                numSamples = Math.min(DEFAULT_MAX_NUM_SAMPLES, Math.max(DEFAULT_MIN_NUM_SAMPLES, calcSamples));
            }
            if (numSamples == 0) {
                FileInputFormat.FileBaseStatistics fileBaseStatistics = stats;
                return fileBaseStatistics;
            }
            if (numSamples < 0) {
                throw new RuntimeException("Error: Invalid number of samples: " + numSamples);
            }
            this.openTimeout = 10000L;
            this.bufferSize = 4096;
            this.lineLengthLimit = MAX_SAMPLE_LEN;
            long offset = 0L;
            long totalNumBytes = 0L;
            long stepSize = stats.getTotalInputSize() / (long)numSamples;
            int fileNum = 0;
            int samplesTaken = 0;
            while (samplesTaken < numSamples && fileNum < allFiles.size()) {
                FileStatus file = allFiles.get(fileNum);
                FileInputSplit split = new FileInputSplit(0, file.getPath(), offset, file.getLen() - offset, null);
                try {
                    this.open(split);
                    if (this.readLine()) {
                        totalNumBytes += (long)(this.currLen + this.delimiter.length);
                        ++samplesTaken;
                    }
                }
                finally {
                    super.close();
                }
                offset += stepSize;
                while (fileNum < allFiles.size() && offset >= (file = allFiles.get(fileNum)).getLen()) {
                    offset -= file.getLen();
                    ++fileNum;
                }
            }
            FileInputFormat.FileBaseStatistics fileBaseStatistics = new FileInputFormat.FileBaseStatistics(stats.getLastModificationTime(), stats.getTotalInputSize(), (float)totalNumBytes / (float)samplesTaken);
            return fileBaseStatistics;
        }
        catch (IOException ioex) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Could not determine statistics for file '" + this.filePath + "' due to an io error: " + ioex.getMessage());
            }
        }
        catch (Throwable t) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unexpected problen while getting the file statistics for file '" + this.filePath + "': " + t.getMessage(), t);
            }
        }
        finally {
            this.openTimeout = oldTimeout;
            this.bufferSize = oldBufferSize;
            this.lineLengthLimit = oldLineLengthLimit;
        }
        return null;
    }

    @Override
    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        int n = this.bufferSize = this.bufferSize <= 0 ? 0x100000 : this.bufferSize;
        if (this.readBuffer == null || this.readBuffer.length != this.bufferSize) {
            this.readBuffer = new byte[this.bufferSize];
        }
        if (this.wrapBuffer == null || this.wrapBuffer.length < 256) {
            this.wrapBuffer = new byte[256];
        }
        this.readPos = 0;
        this.limit = 0;
        this.overLimit = false;
        this.end = false;
        if (this.splitStart != 0L) {
            this.stream.seek(this.splitStart);
            this.readLine();
            if (this.overLimit) {
                this.end = true;
            }
        } else {
            this.fillBuffer();
        }
    }

    @Override
    public boolean reachedEnd() {
        return this.end;
    }

    @Override
    public OT nextRecord(OT record) throws IOException {
        if (this.readLine()) {
            return this.readRecord(record, this.currBuffer, this.currOffset, this.currLen);
        }
        this.end = true;
        return null;
    }

    @Override
    public void close() throws IOException {
        this.wrapBuffer = null;
        this.readBuffer = null;
        super.close();
    }

    protected final boolean readLine() throws IOException {
        if (this.stream == null || this.overLimit) {
            return false;
        }
        int countInWrapBuffer = 0;
        int i = 0;
        while (true) {
            if (this.readPos >= this.limit && !this.fillBuffer()) {
                if (countInWrapBuffer > 0) {
                    this.setResult(this.wrapBuffer, 0, countInWrapBuffer);
                    return true;
                }
                return false;
            }
            int startPos = this.readPos;
            int count = 0;
            while (this.readPos < this.limit && i < this.delimiter.length) {
                if (this.readBuffer[this.readPos++] == this.delimiter[i]) {
                    ++i;
                    continue;
                }
                i = 0;
            }
            if (i == this.delimiter.length) {
                count = this.readPos - startPos - this.delimiter.length;
                if (countInWrapBuffer > 0) {
                    if (this.wrapBuffer.length < countInWrapBuffer + count) {
                        byte[] nb = new byte[countInWrapBuffer + count];
                        System.arraycopy(this.wrapBuffer, 0, nb, 0, countInWrapBuffer);
                        this.wrapBuffer = nb;
                    }
                    if (count >= 0) {
                        System.arraycopy(this.readBuffer, 0, this.wrapBuffer, countInWrapBuffer, count);
                    }
                    this.setResult(this.wrapBuffer, 0, countInWrapBuffer + count);
                    return true;
                }
                this.setResult(this.readBuffer, startPos, count);
                return true;
            }
            count = this.limit - startPos;
            if ((long)countInWrapBuffer + (long)count > (long)this.lineLengthLimit) {
                throw new IOException("The record length exceeded the maximum record length (" + this.lineLengthLimit + ").");
            }
            if (this.wrapBuffer.length - countInWrapBuffer < count) {
                byte[] tmp = new byte[Math.max(this.wrapBuffer.length * 2, countInWrapBuffer + count)];
                System.arraycopy(this.wrapBuffer, 0, tmp, 0, countInWrapBuffer);
                this.wrapBuffer = tmp;
            }
            System.arraycopy(this.readBuffer, startPos, this.wrapBuffer, countInWrapBuffer, count);
            countInWrapBuffer += count;
        }
    }

    private void setResult(byte[] buffer, int offset, int len) {
        this.currBuffer = buffer;
        this.currOffset = offset;
        this.currLen = len;
    }

    private boolean fillBuffer() throws IOException {
        int read;
        int toRead;
        if (this.splitLength == -1L) {
            int read2 = this.stream.read(this.readBuffer, 0, this.readBuffer.length);
            if (read2 == -1) {
                this.stream.close();
                this.stream = null;
                return false;
            }
            this.readPos = 0;
            this.limit = read2;
            return true;
        }
        int n = toRead = this.splitLength > (long)this.readBuffer.length ? this.readBuffer.length : (int)this.splitLength;
        if (this.splitLength <= 0L) {
            toRead = this.readBuffer.length;
            this.overLimit = true;
        }
        if ((read = this.stream.read(this.readBuffer, 0, toRead)) == -1) {
            this.stream.close();
            this.stream = null;
            return false;
        }
        this.splitLength -= (long)read;
        this.readPos = 0;
        this.limit = read;
        return true;
    }

    public static ConfigBuilder configureDelimitedFormat(FileDataSourceBase<?> target) {
        return new ConfigBuilder(target.getParameters());
    }

    static {
        DelimitedInputFormat.loadGloablConfigParams();
    }

    public static class ConfigBuilder
    extends AbstractConfigBuilder<ConfigBuilder> {
        protected ConfigBuilder(Configuration targetConfig) {
            super(targetConfig);
        }
    }

    protected static class AbstractConfigBuilder<T>
    extends FileInputFormat.AbstractConfigBuilder<T> {
        private static final String NEWLINE_DELIMITER = "\n";

        protected AbstractConfigBuilder(Configuration config) {
            super(config);
        }

        public T recordDelimiter(char delimiter) {
            if (delimiter == '\n') {
                this.config.setString(DelimitedInputFormat.RECORD_DELIMITER, NEWLINE_DELIMITER);
            } else {
                this.config.setString(DelimitedInputFormat.RECORD_DELIMITER, String.valueOf(delimiter));
            }
            AbstractConfigBuilder ret = this;
            return (T)ret;
        }

        public T recordDelimiter(String delimiter) {
            this.config.setString(DelimitedInputFormat.RECORD_DELIMITER, delimiter);
            AbstractConfigBuilder ret = this;
            return (T)ret;
        }

        public T recordDelimiter(String delimiter, String charsetName) {
            this.config.setString(DelimitedInputFormat.RECORD_DELIMITER, delimiter);
            this.config.setString(DelimitedInputFormat.RECORD_DELIMITER_ENCODING, charsetName);
            AbstractConfigBuilder ret = this;
            return (T)ret;
        }

        public T numSamplesForStatistics(int numSamples) {
            this.config.setInteger(DelimitedInputFormat.NUM_STATISTICS_SAMPLES, numSamples);
            AbstractConfigBuilder ret = this;
            return (T)ret;
        }
    }
}

