/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.com.google.common.primitives.Ints;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.util.InstantiationUtil;

public abstract class GenericCsvInputFormat<OT>
extends DelimitedInputFormat<OT> {
    private static final long serialVersionUID = 1L;
    private static final Class<?>[] EMPTY_TYPES = new Class[0];
    private static final boolean[] EMPTY_INCLUDED = new boolean[0];
    private static final char DEFAULT_FIELD_DELIMITER = ',';
    private transient FieldParser<Object>[] fieldParsers;
    private Class<?>[] fieldTypes = EMPTY_TYPES;
    private boolean[] fieldIncluded = EMPTY_INCLUDED;
    private char fieldDelim = (char)44;
    private boolean lenient;
    private boolean skipFirstLineAsHeader;

    protected GenericCsvInputFormat() {
    }

    protected GenericCsvInputFormat(Path filePath) {
        super(filePath);
    }

    public int getNumberOfFieldsTotal() {
        return this.fieldIncluded.length;
    }

    public int getNumberOfNonNullFields() {
        return this.fieldTypes.length;
    }

    public char getFieldDelimiter() {
        return this.fieldDelim;
    }

    public void setFieldDelimiter(char fieldDelim) {
        if (fieldDelim > '\u007f') {
            throw new IllegalArgumentException("The field delimiter must be an ASCII character.");
        }
        this.fieldDelim = fieldDelim;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean isSkippingFirstLineAsHeader() {
        return this.skipFirstLineAsHeader;
    }

    public void setSkipFirstLineAsHeader(boolean skipFirstLine) {
        this.skipFirstLineAsHeader = skipFirstLine;
    }

    protected FieldParser<?>[] getFieldParsers() {
        return this.fieldParsers;
    }

    protected Class<?>[] getGenericFieldTypes() {
        if (this.fieldIncluded.length == this.fieldTypes.length) {
            return this.fieldTypes;
        }
        Class[] types = new Class[this.fieldIncluded.length];
        int k = 0;
        for (int i = 0; i < this.fieldIncluded.length; ++i) {
            if (!this.fieldIncluded[i]) continue;
            types[i] = this.fieldTypes[k++];
        }
        return types;
    }

    protected void setFieldTypesGeneric(Class<?> ... fieldTypes) {
        if (fieldTypes == null) {
            throw new IllegalArgumentException("Field types must not be null.");
        }
        this.fieldIncluded = new boolean[fieldTypes.length];
        ArrayList types = new ArrayList();
        for (int i = 0; i < fieldTypes.length; ++i) {
            Class<?> type = fieldTypes[i];
            if (type == null) continue;
            if (FieldParser.getParserForType(type) == null) {
                throw new IllegalArgumentException("The type '" + type.getName() + "' is not supported for the CSV input format.");
            }
            types.add(type);
            this.fieldIncluded[i] = true;
        }
        Class[] denseTypeArray = types.toArray(new Class[types.size()]);
        this.fieldTypes = denseTypeArray;
    }

    protected void setFieldsGeneric(int[] sourceFieldIndices, Class<?>[] fieldTypes) {
        Preconditions.checkNotNull((Object)sourceFieldIndices);
        Preconditions.checkNotNull(fieldTypes);
        Preconditions.checkArgument((sourceFieldIndices.length == fieldTypes.length ? 1 : 0) != 0, (Object)"Number of field indices and field types must match.");
        for (int i : sourceFieldIndices) {
            if (i >= 0) continue;
            throw new IllegalArgumentException("Field indices must not be smaller than zero.");
        }
        int largestFieldIndex = Ints.max((int[])sourceFieldIndices);
        this.fieldIncluded = new boolean[largestFieldIndex + 1];
        ArrayList types = new ArrayList();
        for (int i = 0; i < fieldTypes.length; ++i) {
            Class<?> type = fieldTypes[i];
            if (type == null) continue;
            if (FieldParser.getParserForType(type) == null) {
                throw new IllegalArgumentException("The type '" + type.getName() + "' is not supported for the CSV input format.");
            }
            types.add(type);
            this.fieldIncluded[sourceFieldIndices[i]] = true;
        }
        Class[] denseTypeArray = types.toArray(new Class[types.size()]);
        this.fieldTypes = denseTypeArray;
    }

    protected void setFieldsGeneric(boolean[] includedMask, Class<?>[] fieldTypes) {
        Preconditions.checkNotNull((Object)includedMask);
        Preconditions.checkNotNull(fieldTypes);
        ArrayList types = new ArrayList();
        int typeIndex = 0;
        for (int i = 0; i < includedMask.length; ++i) {
            Class<?> type;
            if (!includedMask[i]) continue;
            if (typeIndex > fieldTypes.length - 1) {
                throw new IllegalArgumentException("Missing type for included field " + i + ".");
            }
            if ((type = fieldTypes[typeIndex++]) == null) {
                throw new IllegalArgumentException("Type for included field " + i + " should not be null.");
            }
            if (FieldParser.getParserForType(type) == null) {
                throw new IllegalArgumentException("The type '" + type.getName() + "' is not supported for the CSV input format.");
            }
            types.add(type);
        }
        Class[] denseTypeArray = types.toArray(new Class[types.size()]);
        this.fieldTypes = denseTypeArray;
        this.fieldIncluded = includedMask;
    }

    @Override
    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        FieldParser[] parsers = new FieldParser[this.fieldTypes.length];
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            FieldParser p;
            if (this.fieldTypes[i] == null) continue;
            Class<FieldParser<?>> parserType = FieldParser.getParserForType(this.fieldTypes[i]);
            if (parserType == null) {
                throw new RuntimeException("No parser available for type '" + this.fieldTypes[i].getName() + "'.");
            }
            parsers[i] = p = InstantiationUtil.instantiate(parserType, FieldParser.class);
        }
        this.fieldParsers = parsers;
        if (this.skipFirstLineAsHeader && this.splitStart == 0L) {
            this.readLine();
        }
    }

    protected boolean parseRecord(Object[] holders, byte[] bytes, int offset, int numBytes) throws ParseException {
        boolean[] fieldIncluded = this.fieldIncluded;
        int startPos = offset;
        int limit = offset + numBytes;
        int output = 0;
        for (int field = 0; field < fieldIncluded.length; ++field) {
            if (startPos >= limit) {
                if (this.lenient) {
                    return false;
                }
                throw new ParseException("Row too short: " + new String(bytes, offset, numBytes));
            }
            if (fieldIncluded[field]) {
                FieldParser<Object> parser = this.fieldParsers[output];
                Object reuse = holders[output];
                startPos = parser.parseField(bytes, startPos, limit, this.fieldDelim, reuse);
                holders[output] = parser.getLastResult();
                if (startPos < 0) {
                    if (this.lenient) {
                        return false;
                    }
                    String lineAsString = new String(bytes, offset, numBytes);
                    throw new ParseException("Line could not be parsed: '" + lineAsString + "'\n" + "ParserError " + (Object)((Object)parser.getErrorState()) + " \n" + "Expect field types: " + this.fieldTypesToString() + " \n" + "in file: " + this.filePath);
                }
                ++output;
                continue;
            }
            if ((startPos = this.skipFields(bytes, startPos, limit, this.fieldDelim)) >= 0 || this.lenient) continue;
            String lineAsString = new String(bytes, offset, numBytes);
            throw new ParseException("Line could not be parsed: '" + lineAsString + "'\n" + "Expect field types: " + this.fieldTypesToString() + " \n" + "in file: " + this.filePath);
        }
        return true;
    }

    private String fieldTypesToString() {
        StringBuilder string = new StringBuilder();
        string.append(this.fieldTypes[0].toString());
        for (int i = 1; i < this.fieldTypes.length; ++i) {
            string.append(", ").append(this.fieldTypes[i]);
        }
        return string.toString();
    }

    protected int skipFields(byte[] bytes, int startPos, int limit, char delim) {
        byte current;
        int i;
        byte delByte = (byte)delim;
        for (i = startPos; i < limit && ((current = bytes[i]) == 32 || current == 9); ++i) {
        }
        if (i < limit && bytes[i] == 34) {
            ++i;
            while (i < limit && bytes[i] != 34) {
                ++i;
            }
            if (i < limit) {
                ++i;
                while (i < limit && (current = bytes[i]) != delByte) {
                    if (current == 32 || current == 9) {
                        ++i;
                        continue;
                    }
                    return -1;
                }
                return i == limit ? limit : i + 1;
            }
            return -1;
        }
        while (i < limit && bytes[i] != delByte) {
            ++i;
        }
        return i == limit ? limit : i + 1;
    }
}

