/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorWithName;
import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.base.BulkIterationBase;
import org.apache.flink.api.common.operators.base.DeltaIterationBase;
import org.apache.flink.api.common.operators.util.TypeComparable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.types.Value;
import org.apache.flink.util.Visitor;

public class CollectionExecutor {
    private static final boolean DEFAULT_MUTABLE_OBJECT_SAFE_MODE = true;
    private final Map<Operator<?>, List<?>> intermediateResults;
    private final Map<String, Accumulator<?, ?>> accumulators;
    private final Map<String, Value> previousAggregates;
    private final Map<String, Aggregator<?>> aggregators;
    private final ClassLoader classLoader;
    private final boolean mutableObjectSafeMode;

    public CollectionExecutor() {
        this(true);
    }

    public CollectionExecutor(boolean mutableObjectSafeMode) {
        this.mutableObjectSafeMode = mutableObjectSafeMode;
        this.intermediateResults = new HashMap();
        this.accumulators = new HashMap();
        this.previousAggregates = new HashMap<String, Value>();
        this.aggregators = new HashMap();
        this.classLoader = this.getClass().getClassLoader();
    }

    public JobExecutionResult execute(Plan program) throws Exception {
        long startTime = System.currentTimeMillis();
        Collection<GenericDataSinkBase<?>> sinks = program.getDataSinks();
        for (Operator operator : sinks) {
            this.execute(operator);
        }
        long endTime = System.currentTimeMillis();
        Map<String, Object> accumulatorResults = AccumulatorHelper.toResultMap(this.accumulators);
        return new JobExecutionResult(endTime - startTime, accumulatorResults);
    }

    private List<?> execute(Operator<?> operator) throws Exception {
        return this.execute(operator, 0);
    }

    private List<?> execute(Operator<?> operator, int superStep) throws Exception {
        List<Object> result = this.intermediateResults.get(operator);
        if (result != null) {
            return result;
        }
        if (operator instanceof BulkIterationBase) {
            result = this.executeBulkIteration((BulkIterationBase)operator);
        } else if (operator instanceof DeltaIterationBase) {
            result = this.executeDeltaIteration((DeltaIterationBase)operator);
        } else if (operator instanceof SingleInputOperator) {
            result = this.executeUnaryOperator((SingleInputOperator)operator, superStep);
        } else if (operator instanceof DualInputOperator) {
            result = this.executeBinaryOperator((DualInputOperator)operator, superStep);
        } else if (operator instanceof GenericDataSourceBase) {
            result = this.executeDataSource((GenericDataSourceBase)operator);
        } else if (operator instanceof GenericDataSinkBase) {
            this.executeDataSink((GenericDataSinkBase)operator);
            result = Collections.emptyList();
        } else {
            throw new RuntimeException("Cannot execute operator " + operator.getClass().getName());
        }
        this.intermediateResults.put(operator, result);
        return result;
    }

    private <IN> void executeDataSink(GenericDataSinkBase<?> sink) throws Exception {
        Operator<?> inputOp = sink.getInput();
        if (inputOp == null) {
            throw new InvalidProgramException("The data sink " + sink.getName() + " has no input.");
        }
        List<?> input = this.execute(inputOp);
        GenericDataSinkBase<?> typedSink = sink;
        typedSink.executeOnCollections(input);
    }

    private <OUT> List<OUT> executeDataSource(GenericDataSourceBase<?, ?> source) throws Exception {
        GenericDataSourceBase<?, ?> typedSource = source;
        return typedSource.executeOnCollections(this.mutableObjectSafeMode);
    }

    private <IN, OUT> List<OUT> executeUnaryOperator(SingleInputOperator<?, ?, ?> operator, int superStep) throws Exception {
        RuntimeUDFContext ctx;
        Operator<?> inputOp = operator.getInput();
        if (inputOp == null) {
            throw new InvalidProgramException("The unary operation " + operator.getName() + " has no input.");
        }
        List<?> inputData = this.execute(inputOp, superStep);
        SingleInputOperator<?, ?, ?> typedOp = operator;
        if (RichFunction.class.isAssignableFrom(typedOp.getUserCodeWrapper().getUserCodeClass())) {
            ctx = superStep == 0 ? new RuntimeUDFContext(operator.getName(), 1, 0, this.getClass().getClassLoader()) : new IterationRuntimeUDFContext(operator.getName(), 1, 0, superStep, this.classLoader);
            for (Map.Entry<String, Operator<?>> bcInputs : operator.getBroadcastInputs().entrySet()) {
                List<?> bcData = this.execute(bcInputs.getValue());
                ctx.setBroadcastVariable(bcInputs.getKey(), bcData);
            }
        } else {
            ctx = null;
        }
        List<?> result = typedOp.executeOnCollections(inputData, ctx, this.mutableObjectSafeMode);
        if (ctx != null) {
            AccumulatorHelper.mergeInto(this.accumulators, ctx.getAllAccumulators());
        }
        return result;
    }

    private <IN1, IN2, OUT> List<OUT> executeBinaryOperator(DualInputOperator<?, ?, ?, ?> operator, int superStep) throws Exception {
        RuntimeUDFContext ctx;
        Operator<?> inputOp1 = operator.getFirstInput();
        Operator<?> inputOp2 = operator.getSecondInput();
        if (inputOp1 == null) {
            throw new InvalidProgramException("The binary operation " + operator.getName() + " has no first input.");
        }
        if (inputOp2 == null) {
            throw new InvalidProgramException("The binary operation " + operator.getName() + " has no second input.");
        }
        List<?> inputData1 = this.execute(inputOp1, superStep);
        List<?> inputData2 = this.execute(inputOp2, superStep);
        DualInputOperator<?, ?, ?, ?> typedOp = operator;
        if (RichFunction.class.isAssignableFrom(typedOp.getUserCodeWrapper().getUserCodeClass())) {
            ctx = superStep == 0 ? new RuntimeUDFContext(operator.getName(), 1, 0, this.classLoader) : new IterationRuntimeUDFContext(operator.getName(), 1, 0, superStep, this.classLoader);
            for (Map.Entry<String, Operator<?>> bcInputs : operator.getBroadcastInputs().entrySet()) {
                List<?> bcData = this.execute(bcInputs.getValue());
                ctx.setBroadcastVariable(bcInputs.getKey(), bcData);
            }
        } else {
            ctx = null;
        }
        List<?> result = typedOp.executeOnCollections(inputData1, inputData2, ctx, this.mutableObjectSafeMode);
        if (ctx != null) {
            AccumulatorHelper.mergeInto(this.accumulators, ctx.getAllAccumulators());
        }
        return result;
    }

    private <T> List<T> executeBulkIteration(BulkIterationBase<?> iteration) throws Exception {
        Operator inputOp = iteration.getInput();
        if (inputOp == null) {
            throw new InvalidProgramException("The iteration " + iteration.getName() + " has no input (initial partial solution).");
        }
        if (iteration.getNextPartialSolution() == null) {
            throw new InvalidProgramException("The iteration " + iteration.getName() + " has no next partial solution defined (is not closed).");
        }
        List<?> inputData = this.execute(inputOp);
        LinkedHashSet dynamics = new LinkedHashSet();
        DynamicPathCollector dynCollector = new DynamicPathCollector(dynamics);
        iteration.getNextPartialSolution().accept(dynCollector);
        if (iteration.getTerminationCriterion() != null) {
            iteration.getTerminationCriterion().accept(dynCollector);
        }
        for (AggregatorWithName<?> a : iteration.getAggregators().getAllRegisteredAggregators()) {
            this.aggregators.put(a.getName(), a.getAggregator());
        }
        String convCriterionAggName = iteration.getAggregators().getConvergenceCriterionAggregatorName();
        ConvergenceCriterion<?> convCriterion = iteration.getAggregators().getConvergenceCriterion();
        List<?> currentResult = inputData;
        int maxIterations = iteration.getMaximumNumberOfIterations();
        for (int superstep = 1; superstep <= maxIterations; ++superstep) {
            Object v;
            this.intermediateResults.put(iteration.getPartialSolution(), currentResult);
            currentResult = this.execute(iteration.getNextPartialSolution(), superstep);
            if (iteration.getTerminationCriterion() != null) {
                this.execute(iteration.getTerminationCriterion(), superstep);
            }
            if (convCriterion != null && convCriterionAggName != null && convCriterion.isConverged(superstep, v = this.aggregators.get(convCriterionAggName).getAggregate())) break;
            for (Operator operator : dynamics) {
                this.intermediateResults.remove(operator);
            }
            for (Map.Entry entry : this.aggregators.entrySet()) {
                this.previousAggregates.put((String)entry.getKey(), (Value)((Aggregator)entry.getValue()).getAggregate());
                ((Aggregator)entry.getValue()).reset();
            }
        }
        this.previousAggregates.clear();
        this.aggregators.clear();
        return currentResult;
    }

    private <T> List<T> executeDeltaIteration(DeltaIterationBase<?, ?> iteration) throws Exception {
        Operator<?> solutionInput = iteration.getInitialSolutionSet();
        Operator<?> worksetInput = iteration.getInitialWorkset();
        if (solutionInput == null) {
            throw new InvalidProgramException("The delta iteration " + iteration.getName() + " has no initial solution set.");
        }
        if (worksetInput == null) {
            throw new InvalidProgramException("The delta iteration " + iteration.getName() + " has no initial workset.");
        }
        if (iteration.getSolutionSetDelta() == null) {
            throw new InvalidProgramException("The iteration " + iteration.getName() + " has no solution set delta defined (is not closed).");
        }
        if (iteration.getNextWorkset() == null) {
            throw new InvalidProgramException("The iteration " + iteration.getName() + " has no workset defined (is not closed).");
        }
        List<?> solutionInputData = this.execute(solutionInput);
        List<?> worksetInputData = this.execute(worksetInput);
        LinkedHashSet dynamics = new LinkedHashSet();
        DynamicPathCollector dynCollector = new DynamicPathCollector(dynamics);
        iteration.getSolutionSetDelta().accept(dynCollector);
        iteration.getNextWorkset().accept(dynCollector);
        OperatorInformation operatorInfo = iteration.getOperatorInfo();
        TypeInformation solutionType = ((BinaryOperatorInformation)operatorInfo).getFirstInputType();
        int[] keyColumns = iteration.getSolutionSetKeyFields();
        boolean[] inputOrderings = new boolean[keyColumns.length];
        TypeComparator inputComparator = ((CompositeType)solutionType).createComparator(keyColumns, inputOrderings, 0);
        HashMap solutionMap = new HashMap(solutionInputData.size());
        for (Object delta : solutionInputData) {
            TypeComparable wrapper = new TypeComparable(delta, inputComparator);
            solutionMap.put(wrapper, delta);
        }
        List<?> currentWorkset = worksetInputData;
        for (AggregatorWithName<?> a : iteration.getAggregators().getAllRegisteredAggregators()) {
            this.aggregators.put(a.getName(), a.getAggregator());
        }
        int maxIterations = iteration.getMaximumNumberOfIterations();
        for (int superstep = 1; superstep <= maxIterations; ++superstep) {
            ArrayList currentSolution = new ArrayList(solutionMap.size());
            currentSolution.addAll(solutionMap.values());
            this.intermediateResults.put(iteration.getSolutionSet(), currentSolution);
            this.intermediateResults.put(iteration.getWorkset(), currentWorkset);
            List<?> solutionSetDelta = this.execute(iteration.getSolutionSetDelta(), superstep);
            this.intermediateResults.put(iteration.getSolutionSetDelta(), solutionSetDelta);
            for (Object obj : solutionSetDelta) {
                TypeComparable wrapper = new TypeComparable(obj, inputComparator);
                solutionMap.put(wrapper, obj);
            }
            currentWorkset = this.execute(iteration.getNextWorkset(), superstep);
            if (currentWorkset.isEmpty()) break;
            for (Operator operator : dynamics) {
                this.intermediateResults.remove(operator);
            }
            for (Map.Entry entry : this.aggregators.entrySet()) {
                this.previousAggregates.put((String)entry.getKey(), (Value)((Aggregator)entry.getValue()).getAggregate());
                ((Aggregator)entry.getValue()).reset();
            }
        }
        this.previousAggregates.clear();
        this.aggregators.clear();
        ArrayList currentSolution = new ArrayList(solutionMap.size());
        currentSolution.addAll(solutionMap.values());
        return currentSolution;
    }

    private class IterationRuntimeUDFContext
    extends RuntimeUDFContext
    implements IterationRuntimeContext {
        private final int superstep;

        public IterationRuntimeUDFContext(String name, int numParallelSubtasks, int subtaskIndex, int superstep, ClassLoader classloader) {
            super(name, numParallelSubtasks, subtaskIndex, classloader);
            this.superstep = superstep;
        }

        @Override
        public int getSuperstepNumber() {
            return this.superstep;
        }

        @Override
        public <T extends Aggregator<?>> T getIterationAggregator(String name) {
            return (T)((Aggregator)CollectionExecutor.this.aggregators.get(name));
        }

        @Override
        public <T extends Value> T getPreviousIterationAggregate(String name) {
            return (T)((Value)CollectionExecutor.this.previousAggregates.get(name));
        }
    }

    private static final class DynamicPathCollector
    implements Visitor<Operator<?>> {
        private final Set<Operator<?>> visited = new HashSet();
        private final Set<Operator<?>> dynamicPathOperations;

        public DynamicPathCollector(Set<Operator<?>> dynamicPathOperations) {
            this.dynamicPathOperations = dynamicPathOperations;
        }

        @Override
        public boolean preVisit(Operator<?> op) {
            return this.visited.add(op);
        }

        @Override
        public void postVisit(Operator<?> op) {
            if (op instanceof SingleInputOperator) {
                SingleInputOperator siop = (SingleInputOperator)op;
                if (this.dynamicPathOperations.contains(siop.getInput())) {
                    this.dynamicPathOperations.add(op);
                } else {
                    for (Operator<?> o : siop.getBroadcastInputs().values()) {
                        if (!this.dynamicPathOperations.contains(o)) continue;
                        this.dynamicPathOperations.add(op);
                        break;
                    }
                }
            } else if (op instanceof DualInputOperator) {
                DualInputOperator siop = (DualInputOperator)op;
                if (this.dynamicPathOperations.contains(siop.getFirstInput())) {
                    this.dynamicPathOperations.add(op);
                } else if (this.dynamicPathOperations.contains(siop.getSecondInput())) {
                    this.dynamicPathOperations.add(op);
                } else {
                    for (Operator<?> o : siop.getBroadcastInputs().values()) {
                        if (!this.dynamicPathOperations.contains(o)) continue;
                        this.dynamicPathOperations.add(op);
                        break;
                    }
                }
            } else if (op.getClass() == BulkIterationBase.PartialSolutionPlaceHolder.class || op.getClass() == DeltaIterationBase.WorksetPlaceHolder.class || op.getClass() == DeltaIterationBase.SolutionSetPlaceHolder.class) {
                this.dynamicPathOperations.add(op);
            } else if (!(op instanceof GenericDataSourceBase)) {
                throw new RuntimeException("Cannot handle operator type " + op.getClass().getName());
            }
        }
    }
}

