/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.List;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.InitializeOnMaster;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.types.Nothing;
import org.apache.flink.util.Visitor;

public class GenericDataSinkBase<IN>
extends Operator<Nothing> {
    protected final UserCodeWrapper<? extends OutputFormat<IN>> formatWrapper;
    protected Operator<IN> input = null;
    private Ordering localOrdering;
    private Ordering partitionOrdering;
    private DataDistribution distribution;

    public GenericDataSinkBase(OutputFormat<IN> f, UnaryOperatorInformation<IN, Nothing> operatorInfo, String name) {
        super(operatorInfo, name);
        Preconditions.checkNotNull(f, (Object)"The OutputFormat may not be null.");
        this.formatWrapper = new UserCodeObjectWrapper<OutputFormat<IN>>(f);
    }

    public GenericDataSinkBase(UserCodeWrapper<? extends OutputFormat<IN>> f, UnaryOperatorInformation<IN, Nothing> operatorInfo, String name) {
        super(operatorInfo, name);
        Preconditions.checkNotNull(f, (Object)"The OutputFormat class may not be null.");
        this.formatWrapper = f;
    }

    public Operator<IN> getInput() {
        return this.input;
    }

    public void setInput(Operator<IN> input) {
        Preconditions.checkNotNull(input, (Object)"The input may not be null.");
        this.input = input;
    }

    @Deprecated
    public void setInputs(Operator<IN> ... inputs) {
        Preconditions.checkNotNull(inputs, (Object)"The inputs may not be null.");
        this.input = Operator.createUnionCascade(inputs);
    }

    @Deprecated
    public void setInputs(List<Operator<IN>> inputs) {
        Preconditions.checkNotNull(inputs, (Object)"The inputs may not be null.");
        this.input = Operator.createUnionCascade(inputs);
    }

    @Deprecated
    public void addInput(Operator<IN> ... inputs) {
        Preconditions.checkNotNull(inputs, (Object)"The input may not be null.");
        this.input = Operator.createUnionCascade(this.input, inputs);
    }

    @Deprecated
    public void addInputs(List<? extends Operator<IN>> inputs) {
        Preconditions.checkNotNull(inputs, (Object)"The inputs may not be null.");
        this.input = GenericDataSinkBase.createUnionCascade(this.input, inputs.toArray(new Operator[inputs.size()]));
    }

    public void setGlobalOrder(Ordering globalOrder) {
        this.localOrdering = globalOrder;
        this.setRangePartitioned(globalOrder);
    }

    public void setGlobalOrder(Ordering globalOrder, DataDistribution distribution) {
        this.localOrdering = globalOrder;
        this.setRangePartitioned(globalOrder, distribution);
    }

    public Ordering getLocalOrder() {
        return this.localOrdering;
    }

    public void setLocalOrder(Ordering localOrder) {
        this.localOrdering = localOrder;
    }

    public Ordering getPartitionOrdering() {
        return this.partitionOrdering;
    }

    public void setRangePartitioned(Ordering partitionOrdering) {
        throw new UnsupportedOperationException("Range partitioning is currently only supported with a user supplied data distribution.");
    }

    public void setRangePartitioned(Ordering partitionOrdering, DataDistribution distribution) {
        if (partitionOrdering.getNumberOfFields() != distribution.getNumberOfFields()) {
            throw new IllegalArgumentException("The number of keys in the distribution must match number of ordered fields.");
        }
        this.partitionOrdering = partitionOrdering;
        this.distribution = distribution;
    }

    public DataDistribution getDataDistribution() {
        return this.distribution;
    }

    public UserCodeWrapper<? extends OutputFormat<IN>> getFormatWrapper() {
        return this.formatWrapper;
    }

    @Override
    public UserCodeWrapper<? extends OutputFormat<IN>> getUserCodeWrapper() {
        return this.formatWrapper;
    }

    @Override
    public void accept(Visitor<Operator<?>> visitor) {
        boolean descend = visitor.preVisit(this);
        if (descend) {
            this.input.accept(visitor);
            visitor.postVisit(this);
        }
    }

    protected void executeOnCollections(List<IN> inputData) throws Exception {
        OutputFormat<IN> format = this.formatWrapper.getUserCodeObject();
        if (format instanceof InitializeOnMaster) {
            ((InitializeOnMaster)((Object)format)).initializeGlobal(1);
        }
        format.configure(this.parameters);
        format.open(0, 1);
        for (IN element : inputData) {
            format.writeRecord(element);
        }
        format.close();
        if (format instanceof FinalizeOnMaster) {
            ((FinalizeOnMaster)((Object)format)).finalizeGlobal(1);
        }
    }

    @Override
    public String toString() {
        return this.name;
    }
}

